/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import java.util.Iterator;
import java.util.Map;

public final class CodecUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static byte[] intToBytes(int num) {
        byte[] result = new byte[]{(byte)(num >>> 24), (byte)(num >>> 16), (byte)(num >>> 8), (byte)num};
        return result;
    }

    public static int bytesToInt(byte[] ary) {
        return ary[3] & 0xFF | ary[2] << 8 & 0xFF00 | ary[1] << 16 & 0xFF0000 | ary[0] << 24 & 0xFF000000;
    }

    public static byte[] short2bytes(short num) {
        byte[] result = new byte[]{(byte)(num >>> 8), (byte)num};
        return result;
    }

    public static byte[] copyOf(byte[] src, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(src, 0, dest, 0, Math.min(src.length, length));
        return dest;
    }

    public static byte[] parseHigh4Low4Bytes(byte b) {
        return new byte[]{(byte)(b >> 4), (byte)(b & 0xF)};
    }

    public static byte buildHigh4Low4Bytes(byte high4, byte low4) {
        return (byte)((high4 << 4) + low4);
    }

    public static byte[] parseHigh2Low6Bytes(byte b) {
        return new byte[]{(byte)(b >> 6), (byte)(b & 0x3F)};
    }

    public static byte buildHigh2Low6Bytes(byte high2, byte low6) {
        return (byte)((high2 << 6) + low6);
    }

    public static String byteToBits(byte b) {
        return "" + (byte)(b >> 7 & 1) + (byte)(b >> 6 & 1) + (byte)(b >> 5 & 1) + (byte)(b >> 4 & 1) + (byte)(b >> 3 & 1) + (byte)(b >> 2 & 1) + (byte)(b >> 1 & 1) + (byte)(b >> 0 & 1);
    }

    public static byte bitsToByte(String bits) {
        byte b = 0;
        int i = bits.length() - 1;
        int j = 0;
        while (i >= 0) {
            char c = bits.charAt(i);
            if (c == '1') {
                b = (byte)(b + (1 << j));
            }
            --i;
            ++j;
        }
        return b;
    }

    public static boolean startsWith(byte[] bs, byte[] head) {
        if (bs.length < head.length) {
            return false;
        }
        for (int i = 0; i < head.length; ++i) {
            if (head[i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean[] byte2Booleans(byte b) {
        boolean[] array = new boolean[8];
        for (int i = 7; i >= 0; --i) {
            array[i] = (b & 1) == 1;
            b = (byte)(b >> 1);
        }
        return array;
    }

    public static byte booleansToByte(boolean[] array) {
        if (array != null && array.length > 0) {
            byte b = 0;
            for (int i = 0; i <= 7; ++i) {
                if (!array[i]) continue;
                int nn = 1 << 7 - i;
                b = (byte)(b + nn);
            }
            return b;
        }
        return 0;
    }

    public static boolean getBooleanFromByte(byte modifiers, int i) {
        if (i > 7 || i < 0) {
            throw new IllegalArgumentException("Index must between 0-7!");
        }
        return (modifiers >> i & 1) == 1;
    }

    public static byte setBooleanToByte(byte modifiers, int i, boolean bool) {
        boolean old = CodecUtils.getBooleanFromByte(modifiers, i);
        if (old && !bool) {
            return (byte)(modifiers - (1 << i));
        }
        if (!old && bool) {
            return (byte)(modifiers + (1 << i));
        }
        return modifiers;
    }

    public static void flatCopyTo(String prefix, Map<String, Object> sourceMap, Map<String, String> dstMap) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            String key = prefix + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                dstMap.put(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                dstMap.put(key, value.toString());
                continue;
            }
            if (!(value instanceof Map)) continue;
            CodecUtils.flatCopyTo(key + ".", (Map)value, dstMap);
        }
    }

    public static void treeCopyTo(String prefix, Map<String, String> sourceMap, Map<String, String> dstMap, boolean remove) {
        Iterator<Map.Entry<String, String>> it = sourceMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getKey().startsWith(prefix)) continue;
            dstMap.put(entry.getKey().substring(prefix.length()), entry.getValue());
            if (!remove) continue;
            it.remove();
        }
    }
}

