/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.sofahessian;

import com.alipay.hessian.ClassNameFilter;
import com.alipay.hessian.ClassNameResolver;
import com.alipay.hessian.NameBlackListFilter;
import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.codec.sofahessian.BlackListFileLoader;
import com.alipay.sofa.rpc.codec.sofahessian.CustomHessianSerializerManager;
import com.alipay.sofa.rpc.codec.sofahessian.GenericMultipleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.sofahessian.GenericSingleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.sofahessian.MultipleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.sofahessian.SingleClassLoaderSofaSerializerFactory;
import com.alipay.sofa.rpc.codec.sofahessian.serialize.CustomHessianSerializer;
import com.alipay.sofa.rpc.codec.sofahessian.serialize.SofaRequestHessianSerializer;
import com.alipay.sofa.rpc.codec.sofahessian.serialize.SofaResponseHessianSerializer;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.SofaConfigs;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayInputStream;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayOutputStream;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteStreamWrapperByteBuf;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

@Extension(value="hessian2", code=1)
public class SofaHessianSerializer
extends AbstractSerializer {
    protected SerializerFactory serializerFactory;
    protected SerializerFactory genericSerializerFactory;

    public SofaHessianSerializer() {
        boolean enableMultipleClassLoader = RpcConfigs.getBooleanValue("multiple.classloader.enable");
        this.serializerFactory = this.getSerializerFactory(enableMultipleClassLoader, false);
        this.genericSerializerFactory = this.getSerializerFactory(enableMultipleClassLoader, true);
        if (RpcConfigs.getBooleanValue("serialize.blacklist.enable") && SofaConfigs.getBooleanValue("rpc_tr_serialize_blacklist", true)) {
            ClassNameResolver resolver = new ClassNameResolver();
            resolver.addFilter((ClassNameFilter)new NameBlackListFilter(BlackListFileLoader.SOFA_SERIALIZE_BLACK_LIST, 8192));
            this.serializerFactory.setClassNameResolver(resolver);
            this.genericSerializerFactory.setClassNameResolver(resolver);
        } else {
            this.serializerFactory.setClassNameResolver(null);
            this.genericSerializerFactory.setClassNameResolver(null);
        }
        CustomHessianSerializerManager.addSerializer(SofaRequest.class, new SofaRequestHessianSerializer(this.serializerFactory, this.genericSerializerFactory));
        CustomHessianSerializerManager.addSerializer(SofaResponse.class, new SofaResponseHessianSerializer(this.serializerFactory, this.genericSerializerFactory));
    }

    protected SerializerFactory getSerializerFactory(boolean multipleClassLoader, boolean generic) {
        if (generic) {
            return multipleClassLoader ? new GenericMultipleClassLoaderSofaSerializerFactory() : new GenericSingleClassLoaderSofaSerializerFactory();
        }
        return multipleClassLoader ? new MultipleClassLoaderSofaSerializerFactory() : new SingleClassLoaderSofaSerializerFactory();
    }

    @Override
    public AbstractByteBuf encode(Object object, Map<String, String> context) {
        CustomHessianSerializer serializer = CustomHessianSerializerManager.getSerializer(object.getClass());
        if (serializer != null) {
            return serializer.encodeObject(object, context);
        }
        UnsafeByteArrayOutputStream byteArray = new UnsafeByteArrayOutputStream();
        Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
        try {
            output.setSerializerFactory(this.serializerFactory);
            output.writeObject(object);
            output.close();
            return new ByteStreamWrapperByteBuf(byteArray);
        }
        catch (Exception e) {
            throw this.buildSerializeError(e.getMessage(), e);
        }
    }

    @Override
    public Object decode(AbstractByteBuf data, Class clazz, Map<String, String> context) throws SofaRpcException {
        if (clazz == null) {
            throw this.buildDeserializeError("class is null!");
        }
        CustomHessianSerializer serializer = CustomHessianSerializerManager.getSerializer(clazz);
        if (serializer != null) {
            return serializer.decodeObject(data, context);
        }
        try {
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(data.array());
            Hessian2Input input = new Hessian2Input((InputStream)inputStream);
            input.setSerializerFactory(this.serializerFactory);
            Object object = input.readObject();
            input.close();
            return object;
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
    }

    @Override
    public void decode(AbstractByteBuf data, Object template, Map<String, String> context) throws SofaRpcException {
        if (template == null) {
            throw this.buildDeserializeError("template is null!");
        }
        CustomHessianSerializer serializer = CustomHessianSerializerManager.getSerializer(template.getClass());
        if (serializer == null) {
            throw this.buildDeserializeError(template.getClass() + " template is not supported");
        }
        serializer.decodeObjectByTemplate(data, context, template);
    }
}

