/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.bolt;

import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayInputStream;
import com.alipay.sofa.rpc.common.struct.UnsafeByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class SimpleMapSerializer {
    public byte[] encode(Map<String, String> map) throws SerializationException {
        if (map == null || map.isEmpty()) {
            return null;
        }
        UnsafeByteArrayOutputStream out = new UnsafeByteArrayOutputStream(64);
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.writeString(out, entry.getKey());
                this.writeString(out, entry.getValue());
            }
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new SerializationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<String, String> decode(byte[] bytes) throws DeserializationException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (bytes == null || bytes.length == 0) {
            return map;
        }
        UnsafeByteArrayInputStream in = new UnsafeByteArrayInputStream(bytes);
        try {
            while (in.available() > 0) {
                String key = this.readString(in);
                String value = this.readString(in);
                map.put(key, value);
            }
            return map;
        }
        catch (IOException ex) {
            throw new DeserializationException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void writeString(OutputStream out, String str) throws IOException {
        if (str == null) {
            this.writeInt(out, -1);
        } else if (str.isEmpty()) {
            this.writeInt(out, 0);
        } else {
            byte[] bs = StringSerializer.encode(str);
            this.writeInt(out, bs.length);
            out.write(bs);
        }
    }

    protected String readString(InputStream in) throws IOException {
        int length = this.readInt(in);
        if (length < 0) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] value = new byte[length];
        in.read(value);
        return StringSerializer.decode(value);
    }

    private void writeInt(OutputStream out, int i) throws IOException {
        out.write((byte)(i >> 24));
        out.write((byte)(i >> 16));
        out.write((byte)(i >> 8));
        out.write(i);
    }

    public int readInt(InputStream in) throws IOException {
        return ((byte)in.read() & 0xFF) << 24 | ((byte)in.read() & 0xFF) << 16 | ((byte)in.read() & 0xFF) << 8 | (byte)in.read() & 0xFF;
    }
}

