/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import com.alipay.sofa.rpc.client.aft.InvocationStat;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.impl.ServiceExceptionInvocationStat;
import com.alipay.sofa.rpc.common.struct.ConcurrentHashSet;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class InvocationStatFactory {
    static final ConcurrentHashMap<InvocationStatDimension, InvocationStat> ALL_STATS = new ConcurrentHashMap();
    static final ConcurrentHashSet<InvocationStatListener> LISTENERS = new ConcurrentHashSet();

    public static InvocationStat getInvocationStat(ConsumerConfig consumerConfig, ProviderInfo providerInfo) {
        String appName = consumerConfig.getAppName();
        if (appName == null) {
            return null;
        }
        if (FaultToleranceConfigManager.isRegulationEffective(appName)) {
            return InvocationStatFactory.getInvocationStat(new InvocationStatDimension(providerInfo, consumerConfig));
        }
        return null;
    }

    public static InvocationStat getInvocationStat(InvocationStatDimension statDimension) {
        InvocationStat invocationStat = ALL_STATS.get(statDimension);
        if (invocationStat == null) {
            invocationStat = new ServiceExceptionInvocationStat(statDimension);
            InvocationStat old = ALL_STATS.putIfAbsent(statDimension, invocationStat);
            if (old != null) {
                invocationStat = old;
            }
            for (InvocationStatListener listener : LISTENERS) {
                listener.onAddInvocationStat(invocationStat);
            }
        }
        return invocationStat;
    }

    public static void removeInvocationStat(InvocationStatDimension statDimension) {
        InvocationStat invocationStat = ALL_STATS.remove(statDimension);
        if (invocationStat != null) {
            for (InvocationStatListener listener : LISTENERS) {
                listener.onRemoveInvocationStat(invocationStat);
            }
        }
    }

    public static void removeInvocationStat(InvocationStat stat) {
        InvocationStatFactory.removeInvocationStat(stat.getDimension());
    }

    public static void removeInvocationStat(ConsumerConfig consumerConfig, ProviderInfo providerInfo) {
        InvocationStatFactory.removeInvocationStat(new InvocationStatDimension(providerInfo, consumerConfig));
    }

    public static void updateInvocationStats(List<InvocationStat> snapshots) {
        for (InvocationStat snapshot : snapshots) {
            InvocationStatFactory.getInvocationStat(snapshot.getDimension()).update(snapshot);
        }
    }

    public static void destroy() {
        ALL_STATS.clear();
        LISTENERS.clear();
    }

    public static void addListener(InvocationStatListener listener) {
        LISTENERS.add(listener);
    }

    public static void removeListener(InvocationStatListener listener) {
        LISTENERS.remove(listener);
    }

    public static interface InvocationStatListener {
        public void onAddInvocationStat(InvocationStat var1);

        public void onRemoveInvocationStat(InvocationStat var1);
    }
}

