/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.LoadBalancer;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;

public class LoadBalancerFactory {
    public static LoadBalancer getLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        try {
            String loadBalancer = consumerBootstrap.getConsumerConfig().getLoadBalancer();
            ExtensionClass<LoadBalancer> ext = ExtensionLoaderFactory.getExtensionLoader(LoadBalancer.class).getExtensionClass(loadBalancer);
            if (ext == null) {
                throw ExceptionUtils.buildRuntime("consumer.loadBalancer", loadBalancer, "Unsupported loadBalancer of client!");
            }
            return ext.getExtInstance(new Class[]{ConsumerBootstrap.class}, new Object[]{consumerBootstrap});
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }
}

