/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.bolt;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.DefaultClientProxyInvoker;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;

public class BoltClientProxyInvoker
extends DefaultClientProxyInvoker {
    public BoltClientProxyInvoker(ConsumerBootstrap bootstrap) {
        super(bootstrap);
    }

    @Override
    protected void cacheCommonData() {
        this.serviceName = ConfigUniqueNameGenerator.getUniqueName(this.consumerConfig);
        this.serializeType = this.parseSerializeType(this.consumerConfig.getSerialization());
    }

    @Override
    protected Byte parseSerializeType(String serialization) {
        Byte serializeType;
        if ("hessian".equals(serialization) || "hessian2".equals(serialization)) {
            serializeType = 1;
        } else if ("protobuf".equals(serialization)) {
            serializeType = 11;
        } else if ("java".equals(serialization)) {
            serializeType = 2;
        } else {
            throw new SofaRpcRuntimeException("Unsupported serialization type");
        }
        return serializeType;
    }
}

