/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap;

import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.alipay.sofa.rpc.server.ProviderProxyInvoker;
import com.alipay.sofa.rpc.server.Server;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="sofa")
public class DefaultProviderBootstrap<T>
extends ProviderBootstrap<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProviderBootstrap.class);
    protected volatile transient boolean exported;
    protected transient Invoker providerProxyInvoker;
    protected static final ConcurrentHashMap<String, AtomicInteger> EXPORTED_KEYS = new ConcurrentHashMap();
    private final ThreadFactory factory = new NamedThreadFactory("DELAY-EXPORT", true);

    protected DefaultProviderBootstrap(ProviderConfig<T> providerConfig) {
        super(providerConfig);
    }

    @Override
    public void export() {
        if (this.providerConfig.getDelay() > 0) {
            Thread thread = this.factory.newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(DefaultProviderBootstrap.this.providerConfig.getDelay());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    DefaultProviderBootstrap.this.doExport();
                }
            });
            thread.start();
        } else {
            this.doExport();
        }
    }

    private void doExport() {
        if (this.exported) {
            return;
        }
        this.checkParameters();
        String appName = this.providerConfig.getAppName();
        ConcurrentHashMap<String, Boolean> hasExportedInCurrent = new ConcurrentHashMap<String, Boolean>();
        List<ServerConfig> serverConfigs = this.providerConfig.getServer();
        for (ServerConfig serverConfig : serverConfigs) {
            AtomicInteger cnt;
            String protocol = serverConfig.getProtocol();
            String key = this.providerConfig.buildKey() + ":" + protocol;
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "Export provider config : {} with bean id {}", key, this.providerConfig.getId());
            }
            if ((cnt = EXPORTED_KEYS.get(key)) == null) {
                cnt = CommonUtils.putToConcurrentMap(EXPORTED_KEYS, key, new AtomicInteger(0));
            }
            int c = cnt.incrementAndGet();
            hasExportedInCurrent.put(serverConfig.getProtocol(), true);
            int maxProxyCount = this.providerConfig.getRepeatedExportLimit();
            if (maxProxyCount <= 0) continue;
            if (c > maxProxyCount) {
                this.decrementCounter(hasExportedInCurrent);
                throw new SofaRpcRuntimeException("Duplicate provider config with key " + key + " has been exported more than " + maxProxyCount + " times!" + " Maybe it's wrong config, please check it." + " Ignore this if you did that on purpose!");
            }
            if (c <= 1 || !LOGGER.isInfoEnabled(appName)) continue;
            LOGGER.infoWithApp(appName, "Duplicate provider config with key {} has been exported! Maybe it's wrong config, please check it. Ignore this if you did that on purpose!", key);
        }
        try {
            List<RegistryConfig> registryConfigs;
            this.providerProxyInvoker = new ProviderProxyInvoker(this.providerConfig);
            if (this.providerConfig.isRegister() && CommonUtils.isNotEmpty(registryConfigs = this.providerConfig.getRegistry())) {
                for (RegistryConfig registryConfig : registryConfigs) {
                    RegistryFactory.getRegistry(registryConfig);
                }
            }
            for (ServerConfig serverConfig : serverConfigs) {
                try {
                    Server server = serverConfig.buildIfAbsent();
                    server.registerProcessor(this.providerConfig, this.providerProxyInvoker);
                    if (!serverConfig.isAutoStart()) continue;
                    server.start();
                }
                catch (SofaRpcRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, "Catch exception when register processor to server: " + serverConfig.getId(), e);
                }
            }
            this.providerConfig.setConfigListener(new ProviderAttributeListener());
            this.register();
        }
        catch (Exception e) {
            this.decrementCounter(hasExportedInCurrent);
            if (e instanceof SofaRpcRuntimeException) {
                throw (SofaRpcRuntimeException)e;
            }
            throw new SofaRpcRuntimeException("Build provider proxy error!", e);
        }
        RpcRuntimeContext.cacheProviderConfig(this);
        this.exported = true;
    }

    private void decrementCounter(Map<String, Boolean> hasExportedInCurrent) {
        for (Map.Entry<String, Boolean> entry : hasExportedInCurrent.entrySet()) {
            String protocol = entry.getKey();
            String key = this.providerConfig.buildKey() + ":" + protocol;
            AtomicInteger cnt = EXPORTED_KEYS.get(key);
            if (cnt == null || cnt.get() <= 0) continue;
            cnt.decrementAndGet();
        }
    }

    protected void checkParameters() {
        Class<?> proxyClass = this.providerConfig.getProxyClass();
        String key = this.providerConfig.buildKey();
        Object ref = this.providerConfig.getRef();
        if (!proxyClass.isInstance(ref)) {
            throw ExceptionUtils.buildRuntime("provider.ref", ref == null ? "null" : ref.getClass().getName(), "This is not an instance of " + this.providerConfig.getInterfaceId() + " in provider config with key " + key + " !");
        }
        if (CommonUtils.isEmpty(this.providerConfig.getServer())) {
            throw ExceptionUtils.buildRuntime("server", "NULL", "Value of \"server\" is not specified in provider config with key " + key + " !");
        }
        this.checkMethods(proxyClass);
    }

    protected void checkMethods(Class<?> itfClass) {
        ConcurrentHashMap<String, Boolean> methodsLimit = new ConcurrentHashMap<String, Boolean>();
        for (Method method : itfClass.getMethods()) {
            Boolean include;
            String methodName = method.getName();
            if (methodsLimit.containsKey(methodName) && LOGGER.isWarnEnabled(this.providerConfig.getAppName())) {
                LOGGER.warnWithApp(this.providerConfig.getAppName(), "Method with same name \"" + itfClass.getName() + "." + methodName + "\" exists ! The usage of overloading method in rpc is deprecated.");
            }
            if ((include = (Boolean)methodsLimit.get(methodName)) == null) {
                include = this.inList(this.providerConfig.getInclude(), this.providerConfig.getExclude(), methodName);
                methodsLimit.putIfAbsent(methodName, include);
            }
            this.providerConfig.setMethodsLimit(methodsLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unExport() {
        if (!this.exported) {
            return;
        }
        DefaultProviderBootstrap defaultProviderBootstrap = this;
        synchronized (defaultProviderBootstrap) {
            String key;
            String protocol;
            if (!this.exported) {
                return;
            }
            String appName = this.providerConfig.getAppName();
            List<ServerConfig> serverConfigs = this.providerConfig.getServer();
            for (ServerConfig serverConfig : serverConfigs) {
                protocol = serverConfig.getProtocol();
                key = this.providerConfig.buildKey() + ":" + protocol;
                if (!LOGGER.isInfoEnabled(appName)) continue;
                LOGGER.infoWithApp(appName, "Unexport provider config : {} {}", key, this.providerConfig.getId() != null ? "with bean id " + this.providerConfig.getId() : "");
            }
            this.unregister();
            this.providerProxyInvoker = null;
            if (serverConfigs != null) {
                for (ServerConfig serverConfig : serverConfigs) {
                    Server server = serverConfig.getServer();
                    if (server == null) continue;
                    try {
                        server.unRegisterProcessor(this.providerConfig, serverConfig.isAutoStart());
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled(appName)) continue;
                        LOGGER.warnWithApp(appName, "Catch exception when unRegister processor to server: " + serverConfig.getId() + ", but you can ignore if it's called by JVM shutdown hook", e);
                    }
                }
            }
            this.providerConfig.setConfigListener(null);
            for (ServerConfig serverConfig : serverConfigs) {
                protocol = serverConfig.getProtocol();
                key = this.providerConfig.buildKey() + ":" + protocol;
                AtomicInteger cnt = EXPORTED_KEYS.get(key);
                if (cnt == null || cnt.decrementAndGet() > 0) continue;
                EXPORTED_KEYS.remove(key);
            }
            RpcRuntimeContext.invalidateProviderConfig(this);
            this.exported = false;
        }
    }

    protected void register() {
        List<RegistryConfig> registryConfigs;
        if (this.providerConfig.isRegister() && (registryConfigs = this.providerConfig.getRegistry()) != null) {
            for (RegistryConfig registryConfig : registryConfigs) {
                Registry registry = RegistryFactory.getRegistry(registryConfig);
                registry.init();
                registry.start();
                try {
                    registry.register(this.providerConfig);
                }
                catch (SofaRpcRuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    String appName = this.providerConfig.getAppName();
                    if (!LOGGER.isWarnEnabled(appName)) continue;
                    LOGGER.warnWithApp(appName, "Catch exception when register to registry: " + registryConfig.getId(), e);
                }
            }
        }
    }

    protected void unregister() {
        List<RegistryConfig> registryConfigs;
        if (this.providerConfig.isRegister() && (registryConfigs = this.providerConfig.getRegistry()) != null) {
            for (RegistryConfig registryConfig : registryConfigs) {
                Registry registry = RegistryFactory.getRegistry(registryConfig);
                try {
                    registry.unRegister(this.providerConfig);
                }
                catch (Exception e) {
                    String appName = this.providerConfig.getAppName();
                    if (!LOGGER.isWarnEnabled(appName)) continue;
                    LOGGER.warnWithApp(appName, "Catch exception when unRegister from registry: " + registryConfig.getId() + ", but you can ignore if it's called by JVM shutdown hook", e);
                }
            }
        }
    }

    protected boolean inList(String includeMethods, String excludeMethods, String methodName) {
        boolean inWhite;
        if (includeMethods != null && !"*".equals(includeMethods) && !(inWhite = (includeMethods = includeMethods + ",").contains(methodName + ","))) {
            return false;
        }
        if (StringUtils.isBlank(excludeMethods)) {
            return true;
        }
        boolean inBlack = (excludeMethods = excludeMethods + ",").contains(methodName + ",");
        return !inBlack;
    }

    private class ProviderAttributeListener
    implements ConfigListener {
        private ProviderAttributeListener() {
        }

        @Override
        public void configChanged(Map newValue) {
        }

        @Override
        public synchronized void attrUpdated(Map newValueMap) {
            String appName = DefaultProviderBootstrap.this.providerConfig.getAppName();
            Map newValues = newValueMap;
            HashMap oldValues = new HashMap();
            boolean reexport = false;
            try {
                for (Map.Entry entry : newValues.entrySet()) {
                    boolean changed;
                    String newValue = (String)entry.getValue();
                    String oldValue = DefaultProviderBootstrap.this.providerConfig.queryAttribute((String)entry.getKey());
                    boolean bl = oldValue == null ? newValue != null : (changed = !oldValue.equals(newValue));
                    if (changed) {
                        oldValues.put(entry.getKey(), oldValue);
                    }
                    reexport = reexport || changed;
                }
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Catch exception when provider attribute compare", e);
                return;
            }
            if (reexport) {
                try {
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, "Reexport service {}", DefaultProviderBootstrap.this.providerConfig.buildKey());
                    }
                    DefaultProviderBootstrap.this.unExport();
                    for (Map.Entry entry : newValues.entrySet()) {
                        DefaultProviderBootstrap.this.providerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    DefaultProviderBootstrap.this.export();
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, "Catch exception when provider attribute changed", e);
                    for (Map.Entry entry : oldValues.entrySet()) {
                        DefaultProviderBootstrap.this.providerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    DefaultProviderBootstrap.this.export();
                }
            }
        }
    }
}

