/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import com.alipay.sofa.boot.gradle.plugin.Marker;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.util.GradleVersion;
import org.springframework.boot.gradle.dsl.SpringBootExtension;
import org.springframework.boot.gradle.plugin.ApplicationPluginAction;
import org.springframework.boot.gradle.plugin.JavaPluginAction;
import org.springframework.boot.gradle.plugin.KotlinPluginAction;
import org.springframework.boot.gradle.plugin.MavenPluginAction;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.plugin.SofaDependencyManagementPluginAction;
import org.springframework.boot.gradle.plugin.UnresolvedDependenciesAnalyzer;
import org.springframework.boot.gradle.plugin.WarPluginAction;

public class SofaBootPlugin
implements Plugin<Project> {
    private static final String SOFA_BOOT_VERSION = SofaBootPlugin.determineSofaBootVersion();
    private static final String BOOT_ARCHIVES_CONFIGURATION_NAME = "bootArchives";
    static final String BOM_COORDINATES = "com.alipay.sofa:sofaboot-dependencies:" + SOFA_BOOT_VERSION;

    public void apply(Project project) {
        this.verifyGradleVersion();
        this.createExtension(project);
        Configuration bootArchives = this.createBootArchivesConfiguration(project);
        this.registerPluginActions(project, bootArchives);
        this.unregisterUnresolvedDependenciesAnalyzer(project);
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.4")) < 0) {
            throw new GradleException("SOFA Boot plugin requires Gradle 4.4 or later. The current version is " + GradleVersion.current());
        }
    }

    private void createExtension(Project project) {
        project.getExtensions().create("springBoot", SpringBootExtension.class, new Object[]{project});
    }

    private Configuration createBootArchivesConfiguration(Project project) {
        Configuration bootArchives = (Configuration)project.getConfigurations().create(BOOT_ARCHIVES_CONFIGURATION_NAME);
        bootArchives.setDescription("Configuration for Spring Boot archive artifacts.");
        return bootArchives;
    }

    private void registerPluginActions(Project project, Configuration bootArchives) {
        SinglePublishedArtifact singlePublishedArtifact = new SinglePublishedArtifact(bootArchives.getArtifacts());
        List<PluginApplicationAction> actions = Arrays.asList(new JavaPluginAction(singlePublishedArtifact), new WarPluginAction(singlePublishedArtifact), new MavenPluginAction(bootArchives.getUploadTaskName()), new SofaDependencyManagementPluginAction(), new ApplicationPluginAction(), new KotlinPluginAction());
        for (PluginApplicationAction action : actions) {
            Class pluginClass = action.getPluginClass();
            if (pluginClass == null) continue;
            project.getPlugins().withType(pluginClass, plugin -> action.execute((Object)project));
        }
    }

    private void unregisterUnresolvedDependenciesAnalyzer(Project project) {
        UnresolvedDependenciesAnalyzer unresolvedDependenciesAnalyzer = new UnresolvedDependenciesAnalyzer();
        project.getConfigurations().all(configuration -> {
            ResolvableDependencies incoming = configuration.getIncoming();
            incoming.afterResolve(resolvableDependencies -> {
                if (incoming.equals(resolvableDependencies)) {
                    unresolvedDependenciesAnalyzer.analyze(configuration.getResolvedConfiguration().getLenientConfiguration().getUnresolvedModuleDependencies());
                }
            });
        });
        project.getGradle().buildFinished(buildResult -> unresolvedDependenciesAnalyzer.buildFinished(project));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String determineSofaBootVersion() {
        URL codeSourceLocation = Marker.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            URLConnection connection = codeSourceLocation.openConnection();
            if (connection instanceof JarURLConnection) {
                return SofaBootPlugin.getImplementationVersion(((JarURLConnection)connection).getJarFile());
            }
            try (JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));){
                String string = SofaBootPlugin.getImplementationVersion(jarFile);
                return string;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

