/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.web;

import com.alipay.sofa.ark.springboot.web.ArkCompositeReactorHttpHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.unix.Errors;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.boot.web.embedded.netty.NettyRouteProvider;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.netty.ChannelBindException;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerRoutes;

public class ArkNettyWebServer
implements WebServer {
    private static final Predicate<HttpServerRequest> ALWAYS = request -> true;
    private static HttpServer arkHttpServer;
    private static final Log logger;
    private final HttpServer httpServer;
    private final BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler;
    private final Duration lifecycleTimeout;
    private List<NettyRouteProvider> routeProviders = Collections.emptyList();
    private static volatile DisposableServer disposableServer;
    private Thread awaitThread;
    private String contextPath;

    public ArkNettyWebServer(String contextPath, HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, Duration lifecycleTimeout) {
        Assert.notNull((Object)httpServer, (String)"HttpServer must not be null");
        Assert.notNull((Object)handlerAdapter, (String)"HandlerAdapter must not be null");
        this.contextPath = contextPath;
        this.lifecycleTimeout = lifecycleTimeout;
        this.handler = handlerAdapter;
        this.httpServer = httpServer.channelGroup((ChannelGroup)new DefaultChannelGroup((EventExecutor)new DefaultEventExecutor()));
        if (arkHttpServer == null) {
            arkHttpServer = this.httpServer;
        }
    }

    public void setRouteProviders(List<NettyRouteProvider> routeProviders) {
        this.routeProviders = routeProviders;
    }

    public void start() throws WebServerException {
        if (disposableServer == null) {
            try {
                disposableServer = this.startHttpServer();
            }
            catch (Exception var2) {
                PortInUseException.ifCausedBy((Exception)var2, ChannelBindException.class, bindException -> {
                    if (bindException.localPort() > 0 && !this.isPermissionDenied(bindException.getCause())) {
                        throw new PortInUseException(bindException.localPort(), (Throwable)var2);
                    }
                });
                throw new WebServerException("Unable to start Netty", (Throwable)var2);
            }
            this.startDaemonAwaitThread(disposableServer);
        }
        if (disposableServer != null) {
            logger.info((Object)("Netty started" + this.getStartedOnMessage(disposableServer) + " with context path " + this.contextPath));
        }
    }

    public void stop() throws WebServerException {
        if (!(this.handler instanceof ArkCompositeReactorHttpHandlerAdapter)) {
            return;
        }
        ((ArkCompositeReactorHttpHandlerAdapter)((Object)this.handler)).unregisterBizReactorHttpHandlerAdapter(this.contextPath);
        if (disposableServer != null && this.httpServer == arkHttpServer) {
            try {
                if (this.lifecycleTimeout != null) {
                    disposableServer.disposeNow(this.lifecycleTimeout);
                } else {
                    disposableServer.disposeNow();
                }
                this.awaitThread.stop();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            logger.info((Object)("Netty stoped" + this.getStartedOnMessage(disposableServer)));
            disposableServer = null;
        }
    }

    public int getPort() {
        if (disposableServer != null) {
            try {
                return disposableServer.port();
            }
            catch (UnsupportedOperationException var2) {
                return -1;
            }
        }
        return -1;
    }

    private String getStartedOnMessage(DisposableServer server) {
        StringBuilder message = new StringBuilder();
        this.tryAppend(message, "port %s", () -> ((DisposableServer)server).port());
        this.tryAppend(message, "host %s", () -> ((DisposableServer)server).host());
        return message.length() > 0 ? " on " + message : "";
    }

    private void tryAppend(StringBuilder message, String format, Supplier<Object> supplier) {
        try {
            Object value = supplier.get();
            message.append(message.length() != 0 ? " " : "");
            message.append(String.format(format, value));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    DisposableServer startHttpServer() {
        HttpServer server = this.httpServer;
        server = this.routeProviders.isEmpty() ? server.handle(this.handler) : server.route(this::applyRouteProviders);
        return this.lifecycleTimeout != null ? server.bindNow(this.lifecycleTimeout) : server.bindNow();
    }

    private boolean isPermissionDenied(Throwable bindExceptionCause) {
        try {
            if (bindExceptionCause instanceof Errors.NativeIoException) {
                return ((Errors.NativeIoException)bindExceptionCause).expectedErr() == -13;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private void applyRouteProviders(HttpServerRoutes routes) {
        for (NettyRouteProvider provider : this.routeProviders) {
            routes = (HttpServerRoutes)provider.apply((Object)routes);
        }
        routes.route(ALWAYS, this.handler);
    }

    private void startDaemonAwaitThread(final DisposableServer disposableServer) {
        this.awaitThread = new Thread("server"){

            @Override
            public void run() {
                disposableServer.onDispose().block();
            }
        };
        this.awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        this.awaitThread.setDaemon(false);
        this.awaitThread.start();
    }

    static {
        logger = LogFactory.getLog(ArkNettyWebServer.class);
    }
}

