/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.plugin;

import com.alipay.sofa.ark.common.util.OrderComparator;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class PluginManagerServiceImpl
implements PluginManagerService {
    private ConcurrentHashMap<String, Plugin> plugins = new ConcurrentHashMap();

    public void registerPlugin(Plugin plugin) {
        if (this.plugins.putIfAbsent(plugin.getPluginName(), plugin) != null) {
            throw new ArkRuntimeException(String.format("duplicate plugin: %s exists.", plugin.getPluginName()));
        }
    }

    public Plugin getPluginByName(String pluginName) {
        return this.plugins.get(pluginName);
    }

    public Set<String> getAllPluginNames() {
        return this.plugins.keySet();
    }

    public List<Plugin> getPluginsInOrder() {
        ArrayList<Plugin> pluginList = new ArrayList<Plugin>(this.plugins.values());
        Collections.sort(pluginList, new OrderComparator());
        return pluginList;
    }
}

