/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.biz;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.BizIdentityUtils;
import com.alipay.sofa.ark.common.util.OrderComparator;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.model.BizModel;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizInfo;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class BizManagerServiceImpl
implements BizManagerService {
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Biz>> bizRegistration = new ConcurrentHashMap();

    public boolean registerBiz(Biz biz) {
        AssertUtils.assertNotNull((Object)biz, (String)"Biz must not be null.");
        AssertUtils.isTrue((biz.getBizState() == BizState.RESOLVED ? 1 : 0) != 0, (String)"BizState must be RESOLVED.", (Object[])new Object[0]);
        this.bizRegistration.putIfAbsent(biz.getBizName(), new ConcurrentHashMap(16));
        ConcurrentHashMap<String, Biz> bizCache = this.bizRegistration.get(biz.getBizName());
        return bizCache.put(biz.getBizVersion(), biz) == null;
    }

    public Biz unRegisterBiz(String bizName, String bizVersion) {
        AssertUtils.isTrue((this.getBizState(bizName, bizVersion) != BizState.RESOLVED ? 1 : 0) != 0, (String)"Biz whose state is resolved must not be un-registered.", (Object[])new Object[0]);
        return this.unRegisterBizStrictly(bizName, bizVersion);
    }

    public Biz unRegisterBizStrictly(String bizName, String bizVersion) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz name must not be empty.", (Object[])new Object[0]);
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizVersion), (String)"Biz version must not be empty.", (Object[])new Object[0]);
        ConcurrentHashMap<String, Biz> bizCache = this.bizRegistration.get(bizName);
        if (bizCache != null) {
            return bizCache.remove(bizVersion);
        }
        return null;
    }

    public List<Biz> getBiz(String bizName) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz name must not be empty.", (Object[])new Object[0]);
        ConcurrentHashMap<String, Biz> bizCache = this.bizRegistration.get(bizName);
        ArrayList<Biz> bizList = new ArrayList<Biz>();
        if (bizCache != null) {
            bizList.addAll(bizCache.values());
        }
        return bizList;
    }

    public Biz getBiz(String bizName, String bizVersion) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz name must not be empty.", (Object[])new Object[0]);
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizVersion), (String)"Biz version must not be empty.", (Object[])new Object[0]);
        ConcurrentHashMap<String, Biz> bizCache = this.bizRegistration.get(bizName);
        if (bizCache != null) {
            return bizCache.get(bizVersion);
        }
        return null;
    }

    public Biz getBizByIdentity(String bizIdentity) {
        AssertUtils.isTrue((boolean)BizIdentityUtils.isValid((String)bizIdentity), (String)"Format of Biz Identity is error.", (Object[])new Object[0]);
        String[] str = bizIdentity.split(":");
        return this.getBiz(str[0], str[1]);
    }

    public Biz getBizByClassLoader(ClassLoader classLoader) {
        for (Map.Entry<String, ConcurrentHashMap<String, Biz>> bizMapEntry : this.bizRegistration.entrySet()) {
            for (Map.Entry<String, Biz> bizEntry : bizMapEntry.getValue().entrySet()) {
                Biz biz = bizEntry.getValue();
                if (!biz.getBizClassLoader().equals(classLoader)) continue;
                return biz;
            }
        }
        return null;
    }

    public Set<String> getAllBizNames() {
        return this.bizRegistration.keySet();
    }

    public Set<String> getAllBizIdentities() {
        HashSet<String> bizIdentities = new HashSet<String>();
        for (Biz biz : this.getBizInOrder()) {
            bizIdentities.add(biz.getIdentity());
        }
        return bizIdentities;
    }

    public List<Biz> getBizInOrder() {
        ArrayList<Biz> bizList = new ArrayList<Biz>();
        for (String bizName : this.bizRegistration.keySet()) {
            bizList.addAll(this.bizRegistration.get(bizName).values());
        }
        Collections.sort(bizList, new OrderComparator());
        return bizList;
    }

    public Biz getActiveBiz(String bizName) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz name must not be empty.", (Object[])new Object[0]);
        Map bizCache = this.bizRegistration.get(bizName);
        if (bizCache != null) {
            for (Biz biz : bizCache.values()) {
                if (biz.getBizState() != BizState.ACTIVATED) continue;
                return biz;
            }
        }
        return null;
    }

    public boolean isActiveBiz(String bizName, String bizVersion) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz name must not be empty.", (Object[])new Object[0]);
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizVersion), (String)"Biz version must not be empty.", (Object[])new Object[0]);
        Map bizCache = this.bizRegistration.get(bizName);
        if (bizCache != null) {
            Biz biz = (Biz)bizCache.get(bizVersion);
            return biz != null && biz.getBizState() == BizState.ACTIVATED;
        }
        return false;
    }

    public void activeBiz(String bizName, String bizVersion) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz name must not be empty.", (Object[])new Object[0]);
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizVersion), (String)"Biz version must not be empty.", (Object[])new Object[0]);
        Biz biz = this.getBiz(bizName, bizVersion);
        Biz activeBiz = this.getActiveBiz(bizName);
        if (biz != null && biz.getBizState() == BizState.DEACTIVATED) {
            if (activeBiz != null) {
                ((BizModel)activeBiz).setBizState(BizState.DEACTIVATED, BizInfo.StateChangeReason.SWITCHED, String.format("switch to new version %s", biz.getIdentity()));
            }
            String message = activeBiz == null ? "" : String.format("switch from old version: %s", activeBiz.getIdentity());
            ((BizModel)biz).setBizState(BizState.ACTIVATED, BizInfo.StateChangeReason.SWITCHED, message);
        }
    }

    public BizState getBizState(String bizName, String bizVersion) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz name must not be empty.", (Object[])new Object[0]);
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizVersion), (String)"Biz version must not be empty.", (Object[])new Object[0]);
        Map bizCache = this.bizRegistration.get(bizName);
        if (bizCache != null) {
            Biz biz = (Biz)bizCache.get(bizVersion);
            return biz != null ? biz.getBizState() : BizState.UNRESOLVED;
        }
        return BizState.UNRESOLVED;
    }

    public BizState getBizState(String bizIdentity) {
        AssertUtils.isTrue((boolean)BizIdentityUtils.isValid((String)bizIdentity), (String)"Format of Biz Identity is error.", (Object[])new Object[0]);
        String[] str = bizIdentity.split(":");
        return this.getBizState(str[0], str[1]);
    }

    public boolean removeAndAddBiz(Biz addingBiz, Biz removingBiz) {
        Set<Map.Entry<String, ConcurrentHashMap<String, Biz>>> bizEntrySet = this.bizRegistration.entrySet();
        bizEntrySet.forEach(item -> {
            String bizName = (String)item.getKey();
            if (removingBiz.getBizName().equals(bizName)) {
                bizEntrySet.remove(item);
                return;
            }
        });
        this.bizRegistration.putIfAbsent(addingBiz.getBizName(), new ConcurrentHashMap(16));
        return this.bizRegistration.get(addingBiz.getBizName()).put(addingBiz.getBizVersion(), addingBiz) == null;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, Biz>> getBizRegistration() {
        return this.bizRegistration;
    }
}

