/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.registry;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.spi.registry.ServiceMetadata;
import com.alipay.sofa.ark.spi.registry.ServiceProvider;

public class ServiceMetadataImpl
implements ServiceMetadata {
    private String uniqueId;
    private Class<?> interfaceClass;
    private ServiceProvider serviceProvider;

    public ServiceMetadataImpl(Class<?> interfaceClass, String uniqueId, ServiceProvider serviceProvider) {
        AssertUtils.assertNotNull(interfaceClass, (String)"Service interface should not be null.");
        AssertUtils.assertNotNull((Object)uniqueId, (String)"Service uniqueId should not be null");
        AssertUtils.assertNotNull((Object)serviceProvider, (String)"Service provider should not be null.");
        this.uniqueId = uniqueId;
        this.interfaceClass = interfaceClass;
        this.serviceProvider = serviceProvider;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public String getServiceName() {
        if (StringUtils.isEmpty((String)this.uniqueId)) {
            return this.interfaceClass.getCanonicalName();
        }
        return String.format("%s:%s", this.interfaceClass.getCanonicalName(), this.uniqueId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceMetadata serviceMetadata = (ServiceMetadata)obj;
        if (!this.uniqueId.equals(serviceMetadata.getUniqueId())) {
            return false;
        }
        if (!this.interfaceClass.equals(serviceMetadata.getInterfaceClass())) {
            return false;
        }
        return this.serviceProvider.equals(serviceMetadata.getServiceProvider());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.uniqueId.hashCode();
        result = 31 * result + this.interfaceClass.hashCode();
        result = 31 * result + this.serviceProvider.hashCode();
        return result;
    }

    public String toString() {
        return String.format("ServiceMetadata{service='%s', provider='%s'}", this.getServiceName(), this.getServiceProvider().toString());
    }
}

