/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.registry;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.container.registry.AbstractServiceProvider;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.registry.ServiceProviderType;

public class PluginServiceProvider
extends AbstractServiceProvider {
    private Plugin plugin;

    public PluginServiceProvider(Plugin plugin) {
        super(ServiceProviderType.ARK_PLUGIN);
        AssertUtils.assertNotNull((Object)plugin, (String)"Plugin should not be null.");
        this.plugin = plugin;
    }

    @Override
    public String getServiceProviderDesc() {
        return String.format("%s:%s", super.getServiceProviderDesc(), this.plugin.getPluginName());
    }

    public int getPriority() {
        return this.plugin.getPriority();
    }

    public String getPluginName() {
        return this.plugin.getPluginName();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.plugin.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PluginServiceProvider serviceProvider = (PluginServiceProvider)obj;
        return this.plugin.equals(serviceProvider.getPlugin());
    }
}

