/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.registry;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.spi.registry.ServiceFilter;
import com.alipay.sofa.ark.spi.registry.ServiceMetadata;
import com.alipay.sofa.ark.spi.registry.ServiceProvider;
import com.alipay.sofa.ark.spi.registry.ServiceProviderType;
import com.alipay.sofa.ark.spi.registry.ServiceReference;

public class DefaultServiceFilter<T>
implements ServiceFilter<T> {
    private ServiceProviderType providerType;
    private Class<?> serviceInterface;
    private String uniqueId;

    public boolean match(ServiceReference serviceReference) {
        AssertUtils.assertNotNull((Object)serviceReference, (String)"ServiceReference should not be null");
        ServiceMetadata serviceMetadata = serviceReference.getServiceMetadata();
        ServiceProvider provider = serviceMetadata.getServiceProvider();
        boolean isMatch = this.matchProviderType(provider.getServiceProviderType());
        isMatch &= this.matchServiceInterface(serviceMetadata.getInterfaceClass());
        return isMatch &= this.matchUniqueId(serviceMetadata.getUniqueId());
    }

    private boolean matchProviderType(ServiceProviderType serviceProviderType) {
        if (this.providerType == null) {
            return true;
        }
        return this.providerType.equals((Object)serviceProviderType);
    }

    private boolean matchServiceInterface(Class serviceInterface) {
        if (this.serviceInterface == null) {
            return true;
        }
        return this.serviceInterface.equals(serviceInterface);
    }

    private boolean matchUniqueId(String uniqueId) {
        if (this.uniqueId == null) {
            return true;
        }
        return this.uniqueId.equals(uniqueId);
    }

    public ServiceProviderType getProviderType() {
        return this.providerType;
    }

    public DefaultServiceFilter setProviderType(ServiceProviderType providerType) {
        this.providerType = providerType;
        return this;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public DefaultServiceFilter setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
        return this;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public DefaultServiceFilter setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }
}

