/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.thread;

import com.alipay.sofa.ark.common.thread.NamedThreadFactory;
import com.alipay.sofa.ark.common.util.ThreadPoolUtils;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CommonThreadPool {
    private int corePoolSize = 10;
    private int maximumPoolSize = 100;
    private int keepAliveTime = 300000;
    private int queueSize = 0;
    private String threadPoolName = "CommonProcessor";
    private boolean isDaemon = false;
    private boolean allowCoreThreadTimeOut = false;
    private boolean prestartAllCoreThreads = false;
    volatile transient ThreadPoolExecutor executor;

    private void init() {
        this.executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.MILLISECONDS, ThreadPoolUtils.buildQueue(this.queueSize), new NamedThreadFactory(this.threadPoolName, this.isDaemon));
        if (this.allowCoreThreadTimeOut) {
            this.executor.allowCoreThreadTimeOut(true);
        }
        if (this.prestartAllCoreThreads) {
            this.executor.prestartAllCoreThreads();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public CommonThreadPool setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public CommonThreadPool setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        return this;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public CommonThreadPool setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public CommonThreadPool setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public CommonThreadPool setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
        return this;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public CommonThreadPool setDaemon(boolean daemon) {
        this.isDaemon = daemon;
        return this;
    }

    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public CommonThreadPool setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public boolean isPrestartAllCoreThreads() {
        return this.prestartAllCoreThreads;
    }

    public CommonThreadPool setPrestartAllCoreThreads(boolean prestartAllCoreThreads) {
        this.prestartAllCoreThreads = prestartAllCoreThreads;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            CommonThreadPool commonThreadPool = this;
            synchronized (commonThreadPool) {
                if (this.executor == null) {
                    this.init();
                }
            }
        }
        return this.executor;
    }
}

