/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.loader;

import com.alipay.sofa.ark.spi.archive.AbstractArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.ContainerArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarContainerArchive
extends AbstractArchive
implements ContainerArchive {
    private final Archive archive;
    private final String SOFA_ARK_CONTAINER_LIB = "lib/";

    public JarContainerArchive(Archive archive) {
        this.archive = archive;
    }

    public URL[] getUrls() throws IOException {
        return this.getUrls(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                return entry.getName().startsWith("lib/");
            }
        });
    }

    public URL getUrl() throws MalformedURLException {
        return this.archive.getUrl();
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    public Archive getNestedArchive(Archive.Entry entry) throws IOException {
        return this.archive.getNestedArchive(entry);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.archive.getInputStream(zipEntry);
    }

    public Iterator<Archive.Entry> iterator() {
        return this.archive.iterator();
    }
}

