/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.bootstrap;

import com.alipay.sofa.ark.bootstrap.AbstractLauncher;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.loader.ExecutableArkBizJar;
import com.alipay.sofa.ark.loader.archive.ExplodedArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import java.io.File;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public abstract class BaseExecutableArchiveLauncher
extends AbstractLauncher {
    private final ExecutableArchive executableArchive;

    public BaseExecutableArchiveLauncher() {
        try {
            this.executableArchive = this.createArchive();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected BaseExecutableArchiveLauncher(ExecutableArchive executableArchive) {
        this.executableArchive = executableArchive;
    }

    @Override
    protected ExecutableArchive getExecutableArchive() {
        return this.executableArchive;
    }

    protected ExecutableArchive createArchive() throws Exception {
        String path;
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getSchemeSpecificPart();
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        File root = FileUtils.file((String)path);
        if (!root.exists()) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        return root.isDirectory() ? new ExecutableArkBizJar(new ExplodedArchive(root)) : new ExecutableArkBizJar(new JarFileArchive(root), root.toURI().toURL());
    }
}

