/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.bean;

import com.alipay.sofa.boot.annotation.AnnotationWrapper;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.spring.bean.SofaBeanNameGenerator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.springframework.core.ParameterNameDiscoverer;

public class SofaParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final AnnotationWrapper<SofaReference> referenceAnnotationWrapper;

    public SofaParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer, AnnotationWrapper<SofaReference> referenceAnnotationWrapper) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        this.referenceAnnotationWrapper = referenceAnnotationWrapper;
    }

    public String[] getParameterNames(Method method) {
        String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        return this.transformParameterNames(parameterNames, parameterTypes, annotations);
    }

    public String[] getParameterNames(Constructor<?> ctor) {
        String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(ctor);
        Class<?>[] parameterTypes = ctor.getParameterTypes();
        Annotation[][] annotations = ctor.getParameterAnnotations();
        return this.transformParameterNames(parameterNames, parameterTypes, annotations);
    }

    protected String[] transformParameterNames(String[] parameterNames, Class<?>[] parameterType, Annotation[][] annotations) {
        if (parameterNames == null) {
            return null;
        }
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof SofaReference)) continue;
                SofaReference delegate = (SofaReference)this.referenceAnnotationWrapper.wrap((Annotation)((SofaReference)annotation));
                Class<?> interfaceType = delegate.interfaceType();
                if (interfaceType.equals(Void.TYPE)) {
                    interfaceType = parameterType[i];
                }
                String uniqueId = delegate.uniqueId();
                parameterNames[i] = SofaBeanNameGenerator.generateSofaReferenceBeanName(interfaceType, uniqueId);
            }
        }
        return parameterNames;
    }
}

