/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.boot.annotation.AnnotationWrapper;
import com.alipay.sofa.boot.annotation.DefaultPlaceHolderBinder;
import com.alipay.sofa.boot.annotation.PlaceHolderBinder;
import com.alipay.sofa.boot.context.processor.SingletonSofaPostProcessor;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.util.BeanDefinitionUtil;
import com.alipay.sofa.boot.util.SmartAnnotationUtils;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.annotation.SofaReferenceBinding;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spring.bean.SofaBeanNameGenerator;
import com.alipay.sofa.runtime.spring.bean.SofaParameterNameDiscoverer;
import com.alipay.sofa.runtime.spring.factory.ReferenceFactoryBean;
import com.alipay.sofa.runtime.spring.factory.ServiceFactoryBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

@SingletonSofaPostProcessor
public class ServiceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware,
InitializingBean,
Ordered {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(ServiceBeanFactoryPostProcessor.class);
    private ApplicationContext applicationContext;
    private SofaRuntimeManager sofaRuntimeManager;
    private BindingConverterFactory bindingConverterFactory;
    private AnnotationWrapper<SofaService> serviceAnnotationWrapper;
    private AnnotationWrapper<SofaReference> referenceAnnotationWrapper;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof AbstractAutowireCapableBeanFactory) {
            ParameterNameDiscoverer parameterNameDiscoverer = ((AbstractAutowireCapableBeanFactory)beanFactory).getParameterNameDiscoverer();
            if (parameterNameDiscoverer == null) {
                parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
            }
            ((AbstractAutowireCapableBeanFactory)beanFactory).setParameterNameDiscoverer((ParameterNameDiscoverer)new SofaParameterNameDiscoverer(parameterNameDiscoverer, this.referenceAnnotationWrapper));
        }
        Arrays.stream(beanFactory.getBeanDefinitionNames()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0))).forEach((key, value) -> this.transformSofaBeanDefinition((String)key, (BeanDefinition)value, (BeanDefinitionRegistry)beanFactory));
    }

    private void transformSofaBeanDefinition(String beanId, BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        if (BeanDefinitionUtil.isFromConfigurationSource((BeanDefinition)beanDefinition)) {
            this.generateSofaServiceDefinitionOnMethod(beanId, (AnnotatedBeanDefinition)beanDefinition, registry);
        } else {
            Class beanClassType = BeanDefinitionUtil.resolveBeanClassType((BeanDefinition)beanDefinition);
            if (beanClassType == null) {
                return;
            }
            this.generateSofaServiceDefinitionOnClass(beanId, beanClassType, beanDefinition, registry);
        }
    }

    private void generateSofaServiceDefinitionOnMethod(String beanId, AnnotatedBeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        Class declaringClass;
        Class returnType;
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        MethodMetadata methodMetadata = beanDefinition.getFactoryMethodMetadata();
        try {
            returnType = ClassUtils.forName((String)methodMetadata.getReturnTypeName(), null);
            declaringClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), null);
        }
        catch (Throwable throwable) {
            LOGGER.error(ErrorCode.convert((String)"01-02001", (Object[])new Object[]{beanId}), throwable);
            return;
        }
        if (methodMetadata instanceof StandardMethodMetadata) {
            candidateMethods.add(((StandardMethodMetadata)methodMetadata).getIntrospectedMethod());
        } else {
            for (Method m : declaringClass.getDeclaredMethods()) {
                if (!m.getName().equals(methodMetadata.getMethodName()) || !m.getReturnType().getTypeName().equals(methodMetadata.getReturnTypeName()) || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, Bean.class)) continue;
                Bean bean = m.getAnnotation(Bean.class);
                HashSet<String> beanNames = new HashSet<String>();
                beanNames.add(m.getName());
                if (bean != null) {
                    beanNames.addAll(Arrays.asList(bean.name()));
                    beanNames.addAll(Arrays.asList(bean.value()));
                }
                if (!beanNames.contains(beanId)) continue;
                candidateMethods.add(m);
            }
        }
        if (candidateMethods.size() == 1) {
            Method method = (Method)candidateMethods.get(0);
            Collection sofaServiceList = SmartAnnotationUtils.getAnnotations((AnnotatedElement)method, SofaService.class);
            if (!sofaServiceList.isEmpty()) {
                sofaServiceList.forEach(annotation -> this.generateSofaServiceDefinition(beanId, (SofaService)annotation, returnType, (BeanDefinition)beanDefinition, registry));
            } else {
                sofaServiceList = SmartAnnotationUtils.getAnnotations((AnnotatedElement)returnType, SofaService.class);
                sofaServiceList.forEach(annotation -> this.generateSofaServiceDefinition(beanId, (SofaService)annotation, returnType, (BeanDefinition)beanDefinition, registry));
            }
            this.generateSofaReferenceDefinition(beanId, (Method)candidateMethods.get(0), registry);
        } else if (candidateMethods.size() > 1) {
            for (Method m : candidateMethods) {
                if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, SofaService.class) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType, SofaService.class)) {
                    throw new FatalBeanException(ErrorCode.convert((String)"01-02002", (Object[])new Object[]{declaringClass.getCanonicalName()}));
                }
                if (!Stream.of(m.getParameterAnnotations()).flatMap(Stream::of).anyMatch(annotation -> annotation instanceof SofaReference)) continue;
                throw new FatalBeanException(ErrorCode.convert((String)"01-02003", (Object[])new Object[]{declaringClass.getCanonicalName()}));
            }
        }
    }

    private void generateSofaReferenceDefinition(String beanId, Method method, BeanDefinitionRegistry registry) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof SofaReference)) continue;
                this.doGenerateSofaReferenceDefinition(registry.getBeanDefinition(beanId), (SofaReference)annotation, parameterTypes[i], registry);
            }
        }
    }

    private void doGenerateSofaReferenceDefinition(BeanDefinition beanDefinition, SofaReference sofaReference, Class<?> parameterType, BeanDefinitionRegistry registry) {
        String uniqueId;
        String referenceId;
        Assert.isTrue((boolean)JvmBinding.JVM_BINDING_TYPE.getType().equals(sofaReference.binding().bindingType()), (String)"Only jvm type of @SofaReference on parameter is supported.");
        sofaReference = (SofaReference)this.referenceAnnotationWrapper.wrap((Annotation)sofaReference);
        Class<?> interfaceType = sofaReference.interfaceType();
        if (interfaceType.equals(Void.TYPE)) {
            interfaceType = parameterType;
        }
        if (!registry.containsBeanDefinition(referenceId = SofaBeanNameGenerator.generateSofaReferenceBeanName(interfaceType, uniqueId = sofaReference.uniqueId()))) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
            builder.getRawBeanDefinition().setScope(beanDefinition.getScope());
            builder.getRawBeanDefinition().setLazyInit(beanDefinition.isLazyInit());
            builder.getRawBeanDefinition().setBeanClass(ReferenceFactoryBean.class);
            builder.addAutowiredProperty("sofaRuntimeContext");
            builder.addAutowiredProperty("bindingConverterFactory");
            builder.addAutowiredProperty("bindingAdapterFactory");
            builder.addPropertyValue("uniqueId", (Object)uniqueId);
            builder.addPropertyValue("interfaceClass", interfaceType);
            builder.addPropertyValue("bindings", this.getSofaReferenceBinding(sofaReference, sofaReference.binding()));
            builder.addPropertyValue("apiType", (Object)true);
            builder.getBeanDefinition().setAttribute("factoryBeanObjectType", interfaceType);
            registry.registerBeanDefinition(referenceId, (BeanDefinition)builder.getBeanDefinition());
        }
        if (beanDefinition.getDependsOn() == null) {
            beanDefinition.setDependsOn(new String[]{referenceId});
        } else {
            String[] added = (String[])ObjectUtils.addObjectToArray((Object[])beanDefinition.getDependsOn(), (Object)referenceId);
            beanDefinition.setDependsOn(added);
        }
    }

    private void generateSofaServiceDefinitionOnClass(String beanId, Class<?> beanClass, BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        SmartAnnotationUtils.getAnnotations(beanClass, SofaService.class).forEach(annotation -> this.generateSofaServiceDefinition(beanId, (SofaService)annotation, beanClass, beanDefinition, registry));
    }

    private void generateSofaServiceDefinition(String beanId, SofaService sofaServiceAnnotation, Class<?> beanClass, BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        if (sofaServiceAnnotation == null) {
            return;
        }
        Class<?> interfaceType = (sofaServiceAnnotation = (SofaService)this.serviceAnnotationWrapper.wrap((Annotation)sofaServiceAnnotation)).interfaceType();
        if (interfaceType.equals(Void.TYPE)) {
            Class<?>[] interfaces = beanClass.getInterfaces();
            if (beanClass.isInterface() || interfaces == null || interfaces.length == 0) {
                interfaceType = beanClass;
            } else if (interfaces.length == 1) {
                interfaceType = interfaces[0];
            } else {
                throw new FatalBeanException(ErrorCode.convert((String)"01-02004", (Object[])new Object[]{beanId}));
            }
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        String serviceId = SofaBeanNameGenerator.generateSofaServiceBeanName(interfaceType, sofaServiceAnnotation.uniqueId(), beanId);
        if (!registry.containsBeanDefinition(serviceId)) {
            builder.getRawBeanDefinition().setScope(beanDefinition.getScope());
            builder.setLazyInit(beanDefinition.isLazyInit());
            builder.getRawBeanDefinition().setBeanClass(ServiceFactoryBean.class);
            builder.addAutowiredProperty("sofaRuntimeContext");
            builder.addAutowiredProperty("bindingConverterFactory");
            builder.addAutowiredProperty("bindingAdapterFactory");
            builder.addPropertyValue("interfaceClass", interfaceType);
            builder.addPropertyValue("uniqueId", (Object)sofaServiceAnnotation.uniqueId());
            builder.addPropertyValue("bindings", this.getSofaServiceBinding(sofaServiceAnnotation, sofaServiceAnnotation.bindings(), interfaceType));
            builder.addPropertyReference("ref", beanId);
            builder.addPropertyValue("beanId", (Object)beanId);
            builder.addPropertyValue("apiType", (Object)true);
            builder.addDependsOn(beanId);
            registry.registerBeanDefinition(serviceId, (BeanDefinition)builder.getBeanDefinition());
        } else {
            LOGGER.warn("SofaService was already registered: {}", (Object)serviceId);
        }
    }

    private List<Binding> getSofaServiceBinding(SofaService sofaServiceAnnotation, SofaServiceBinding[] sofaServiceBindings, Class<?> interfaceType) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (SofaServiceBinding sofaServiceBinding : sofaServiceBindings) {
            BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaServiceBinding.bindingType()));
            if (bindingConverter == null) {
                throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00200", (Object[])new Object[]{sofaServiceBinding.bindingType()}));
            }
            BindingConverterContext bindingConverterContext = new BindingConverterContext();
            bindingConverterContext.setInBinding(false);
            bindingConverterContext.setApplicationContext(this.applicationContext);
            bindingConverterContext.setAppName(this.sofaRuntimeManager.getAppName());
            bindingConverterContext.setAppClassLoader(this.sofaRuntimeManager.getAppClassLoader());
            bindingConverterContext.setInterfaceType(interfaceType);
            Object binding = bindingConverter.convert(sofaServiceAnnotation, sofaServiceBinding, bindingConverterContext);
            bindings.add((Binding)binding);
        }
        return bindings;
    }

    private List<Binding> getSofaReferenceBinding(SofaReference sofaReferenceAnnotation, SofaReferenceBinding sofaReferenceBinding) {
        if (!JvmBinding.XmlConstants.BINDING_TYPE.equals(sofaReferenceBinding.bindingType())) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-02005"));
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaReferenceBinding.bindingType()));
        if (bindingConverter == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00200", (Object[])new Object[]{sofaReferenceBinding.bindingType()}));
        }
        BindingConverterContext bindingConverterContext = new BindingConverterContext();
        bindingConverterContext.setInBinding(true);
        bindingConverterContext.setApplicationContext(this.applicationContext);
        bindingConverterContext.setAppName(this.sofaRuntimeManager.getAppName());
        bindingConverterContext.setAppClassLoader(this.sofaRuntimeManager.getAppClassLoader());
        Object binding = bindingConverter.convert(sofaReferenceAnnotation, sofaReferenceBinding, bindingConverterContext);
        bindings.add((Binding)binding);
        return bindings;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.serviceAnnotationWrapper = AnnotationWrapper.create(SofaService.class).withEnvironment(applicationContext.getEnvironment()).withBinder((PlaceHolderBinder)DefaultPlaceHolderBinder.INSTANCE);
        this.referenceAnnotationWrapper = AnnotationWrapper.create(SofaReference.class).withEnvironment(applicationContext.getEnvironment()).withBinder((PlaceHolderBinder)DefaultPlaceHolderBinder.INSTANCE);
    }

    public int getOrder() {
        return -2147483638;
    }

    public void afterPropertiesSet() throws Exception {
        this.sofaRuntimeManager = (SofaRuntimeManager)this.applicationContext.getBean("sofaRuntimeManager", SofaRuntimeManager.class);
        this.bindingConverterFactory = (BindingConverterFactory)this.applicationContext.getBean("bindingConverterFactory", BindingConverterFactory.class);
    }
}

