/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.boot.annotation.AnnotationWrapper;
import com.alipay.sofa.boot.annotation.DefaultPlaceHolderBinder;
import com.alipay.sofa.boot.annotation.PlaceHolderBinder;
import com.alipay.sofa.boot.context.processor.SingletonSofaPostProcessor;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.component.impl.ReferenceImpl;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.ComponentDefinitionInfo;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@SingletonSofaPostProcessor
public class ReferenceAnnotationBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
PriorityOrdered {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(ReferenceAnnotationBeanPostProcessor.class);
    private final SofaRuntimeContext sofaRuntimeContext;
    private final BindingAdapterFactory bindingAdapterFactory;
    private final BindingConverterFactory bindingConverterFactory;
    private ApplicationContext applicationContext;
    private AnnotationWrapper<SofaReference> annotationWrapper;

    public ReferenceAnnotationBeanPostProcessor(SofaRuntimeContext sofaRuntimeContext, BindingAdapterFactory bindingAdapterFactory, BindingConverterFactory bindingConverterFactory) {
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.bindingAdapterFactory = bindingAdapterFactory;
        this.bindingConverterFactory = bindingConverterFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processSofaReference(bean, beanName);
        return bean;
    }

    private void processSofaReference(Object bean, String beanName) {
        Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, field -> {
            SofaReference sofaReferenceAnnotation = field.getAnnotation(SofaReference.class);
            if (sofaReferenceAnnotation == null) {
                return;
            }
            Class<?> interfaceType = (sofaReferenceAnnotation = (SofaReference)this.annotationWrapper.wrap((Annotation)sofaReferenceAnnotation)).interfaceType();
            if (interfaceType.equals(Void.TYPE)) {
                interfaceType = field.getType();
            }
            Object proxy = this.createReferenceProxy(sofaReferenceAnnotation, interfaceType, beanClass, field.getName(), beanName);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)proxy);
        }, field -> {
            if (!field.isAnnotationPresent(SofaReference.class)) {
                return false;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                LOGGER.warn("SofaReference annotation is not supported on static fields: {}", (Object)field);
                return false;
            }
            return true;
        });
        ReflectionUtils.doWithMethods(beanClass, method -> {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Assert.isTrue((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"method should have one and only one parameter.");
            SofaReference sofaReferenceAnnotation = method.getAnnotation(SofaReference.class);
            if (sofaReferenceAnnotation == null) {
                return;
            }
            Class<?> interfaceType = (sofaReferenceAnnotation = (SofaReference)this.annotationWrapper.wrap((Annotation)sofaReferenceAnnotation)).interfaceType();
            if (interfaceType.equals(Void.TYPE)) {
                interfaceType = parameterTypes[0];
            }
            Object proxy = this.createReferenceProxy(sofaReferenceAnnotation, interfaceType, beanClass, method.getName(), beanName);
            ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{proxy});
        }, method -> method.isAnnotationPresent(SofaReference.class));
    }

    private Object createReferenceProxy(SofaReference sofaReferenceAnnotation, Class<?> interfaceType, Class beanClass, String fieldName, String beanName) {
        ReferenceImpl reference = new ReferenceImpl(sofaReferenceAnnotation.uniqueId(), interfaceType, InterfaceMode.annotation, sofaReferenceAnnotation.jvmFirst());
        reference.setRequired(sofaReferenceAnnotation.required());
        BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaReferenceAnnotation.binding().bindingType()));
        if (bindingConverter == null) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00200", (Object[])new Object[]{sofaReferenceAnnotation.binding().bindingType()}));
        }
        BindingConverterContext bindingConverterContext = new BindingConverterContext();
        bindingConverterContext.setInBinding(true);
        bindingConverterContext.setApplicationContext(this.applicationContext);
        bindingConverterContext.setAppName(this.sofaRuntimeContext.getAppName());
        bindingConverterContext.setAppClassLoader(this.sofaRuntimeContext.getAppClassLoader());
        Object binding = bindingConverter.convert(sofaReferenceAnnotation, sofaReferenceAnnotation.binding(), bindingConverterContext);
        reference.addBinding(binding);
        ComponentDefinitionInfo definitionInfo = new ComponentDefinitionInfo();
        definitionInfo.setInterfaceMode(InterfaceMode.annotation);
        definitionInfo.putInfo("location", fieldName);
        definitionInfo.putInfo("beanId", beanName);
        definitionInfo.putInfo("beanClassName", beanClass.getCanonicalName());
        return ReferenceRegisterHelper.registerReference(reference, this.bindingAdapterFactory, this.sofaRuntimeContext, this.applicationContext, definitionInfo);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.annotationWrapper = AnnotationWrapper.create(SofaReference.class).withEnvironment(applicationContext.getEnvironment()).withBinder((PlaceHolderBinder)DefaultPlaceHolderBinder.INSTANCE);
    }
}

