/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.boot.context.processor.SingletonSofaPostProcessor;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.runtime.api.annotation.SofaClientFactory;
import com.alipay.sofa.runtime.api.client.ClientFactory;
import com.alipay.sofa.runtime.impl.ClientFactoryImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

@SingletonSofaPostProcessor
public class ClientFactoryAnnotationBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private final ClientFactory clientFactory;

    public ClientFactoryAnnotationBeanPostProcessor(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            if (ClientFactory.class.isAssignableFrom(field.getType())) {
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, (Object)this.clientFactory);
            } else if (this.clientFactory instanceof ClientFactoryImpl && ((ClientFactoryImpl)this.clientFactory).getAllClientTypes().contains(field.getType())) {
                Object client = this.clientFactory.getClient(field.getType());
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, client);
            } else {
                throw new RuntimeException(ErrorCode.convert((String)"01-02000"));
            }
        }, field -> !Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(SofaClientFactory.class));
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

