/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.impl;

import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.impl.ComponentManagerImpl;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.spring.RuntimeShutdownAware;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

public class StandardSofaRuntimeManager
implements SofaRuntimeManager,
ApplicationContextAware {
    private final String appName;
    private final List<RuntimeShutdownAware> runtimeShutdownAwareList = new CopyOnWriteArrayList<RuntimeShutdownAware>();
    private ComponentManagerImpl componentManager;
    private ClientFactoryInternal clientFactoryInternal;
    private SofaRuntimeContext sofaRuntimeContext;
    private ClassLoader appClassLoader;
    private ApplicationContext rootApplicationContext;

    public StandardSofaRuntimeManager(String appName, ClassLoader appClassLoader, ClientFactoryInternal clientFactoryInternal) {
        this.appName = appName;
        this.appClassLoader = appClassLoader;
        this.clientFactoryInternal = clientFactoryInternal;
        this.componentManager = new ComponentManagerImpl(clientFactoryInternal, appClassLoader);
        this.sofaRuntimeContext = new SofaRuntimeContext(this);
        this.componentManager.setSofaRuntimeContext(this.sofaRuntimeContext);
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public ClientFactoryInternal getClientFactoryInternal() {
        return this.clientFactoryInternal;
    }

    @Override
    public SofaRuntimeContext getSofaRuntimeContext() {
        return this.sofaRuntimeContext;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    @Override
    public void shutdown() throws ServiceRuntimeException {
        try {
            for (RuntimeShutdownAware shutdownAware : this.runtimeShutdownAwareList) {
                shutdownAware.shutdown();
            }
            if (this.componentManager != null) {
                this.componentManager.shutdown();
            }
            this.clear();
        }
        catch (Throwable throwable) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-03100"), throwable);
        }
    }

    @Override
    public void shutDownExternally() throws ServiceRuntimeException {
        try {
            AbstractApplicationContext applicationContext = (AbstractApplicationContext)this.rootApplicationContext;
            if (applicationContext.isActive()) {
                applicationContext.close();
            }
            this.appClassLoader = null;
        }
        catch (Throwable throwable) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-03100"), throwable);
        }
    }

    @Override
    public void registerShutdownAware(RuntimeShutdownAware callback) {
        this.runtimeShutdownAwareList.add(callback);
    }

    @Override
    public ApplicationContext getRootApplicationContext() {
        return this.rootApplicationContext;
    }

    protected void clear() {
        this.componentManager = null;
        this.sofaRuntimeContext = null;
        this.clientFactoryInternal = null;
        this.runtimeShutdownAwareList.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.rootApplicationContext = applicationContext;
    }
}

