/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.async;

import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.runtime.async.AsyncInitMethodManager;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;

public class AsyncInitializeBeanMethodInvoker
implements MethodInterceptor {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(AsyncInitializeBeanMethodInvoker.class);
    private final AsyncInitMethodManager asyncInitMethodManager;
    private final Object targetObject;
    private final String asyncMethodName;
    private final String beanName;
    private final CountDownLatch initCountDownLatch = new CountDownLatch(1);
    private volatile boolean isAsyncCalling = false;
    private volatile boolean isAsyncCalled = false;

    public AsyncInitializeBeanMethodInvoker(AsyncInitMethodManager asyncInitMethodManager, Object targetObject, String beanName, String methodName) {
        this.asyncInitMethodManager = asyncInitMethodManager;
        this.targetObject = targetObject;
        this.beanName = beanName;
        this.asyncMethodName = methodName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.asyncInitMethodManager.isStartUpFinish()) {
            return invocation.getMethod().invoke(this.targetObject, invocation.getArguments());
        }
        Method method = invocation.getMethod();
        String methodName = method.getName();
        if (!this.isAsyncCalled && methodName.equals(this.asyncMethodName)) {
            this.isAsyncCalled = true;
            this.isAsyncCalling = true;
            this.asyncInitMethodManager.submitTask(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    invocation.getMethod().invoke(this.targetObject, invocation.getArguments());
                    LOGGER.info("{}({}) {} method execute {}dms.", new Object[]{this.targetObject.getClass().getName(), this.beanName, methodName, System.currentTimeMillis() - startTime});
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.asyncMethodFinish();
                }
            });
            return null;
        }
        if (this.isAsyncCalling) {
            long startTime = System.currentTimeMillis();
            this.initCountDownLatch.await();
            LOGGER.info("{}({}) {} method wait {}ms.", new Object[]{this.targetObject.getClass().getName(), this.beanName, methodName, System.currentTimeMillis() - startTime});
        }
        return invocation.getMethod().invoke(this.targetObject, invocation.getArguments());
    }

    void asyncMethodFinish() {
        this.initCountDownLatch.countDown();
        this.isAsyncCalling = false;
    }
}

