/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.helper;

import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.Reference;
import com.alipay.sofa.runtime.service.component.ReferenceComponent;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.ComponentDefinitionInfo;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.Set;
import org.springframework.context.ApplicationContext;

public class ReferenceRegisterHelper {
    public static Object registerReference(Reference reference, BindingAdapterFactory bindingAdapterFactory, SofaRuntimeContext sofaRuntimeContext) {
        return ReferenceRegisterHelper.registerReference(reference, bindingAdapterFactory, sofaRuntimeContext, null, null);
    }

    public static Object registerReference(Reference reference, BindingAdapterFactory bindingAdapterFactory, SofaRuntimeContext sofaRuntimeContext, ApplicationContext applicationContext, ComponentDefinitionInfo definitionInfo) {
        Binding binding = (Binding)reference.getBindings().toArray()[0];
        if (!binding.getBindingType().equals(JvmBinding.JVM_BINDING_TYPE) && !SofaRuntimeProperties.isDisableJvmFirst(sofaRuntimeContext) && reference.isJvmFirst()) {
            reference.addBinding(new JvmBinding());
        }
        ComponentManager componentManager = sofaRuntimeContext.getComponentManager();
        ReferenceComponent referenceComponent = new ReferenceComponent(reference, new DefaultImplementation(), bindingAdapterFactory, sofaRuntimeContext);
        Property property = new Property();
        property.setName("source");
        property.setValue(definitionInfo);
        referenceComponent.getProperties().put("source", property);
        if (componentManager.isRegistered(referenceComponent.getName())) {
            return componentManager.getComponentInfo(referenceComponent.getName()).getImplementation().getTarget();
        }
        ComponentInfo componentInfo = componentManager.registerAndGet(referenceComponent);
        componentInfo.setApplicationContext(applicationContext);
        return componentInfo.getImplementation().getTarget();
    }

    public static int generateBindingHashCode(Reference reference) {
        Set bindings = reference.getBindings();
        int result = 1;
        for (Binding binding : bindings) {
            result = result * 31 + binding.getBindingHashCode();
        }
        ClassLoader cl = reference.getInterfaceType().getClassLoader();
        if (cl != null) {
            result += reference.getInterfaceType().getClassLoader().hashCode();
        }
        return result;
    }
}

