/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.compatibility;

import com.alipay.sofa.boot.compatibility.CompatibilityVerifier;
import com.alipay.sofa.boot.compatibility.CompositeCompatibilityVerifier;
import com.alipay.sofa.runtime.log.SofaLogger;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CompatibilityVerifierApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public static final String COMPATIBILITY_VERIFIER_ENABLED = "sofa.boot.compatibility-verifier.enabled";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (!Boolean.parseBoolean(environment.getProperty(COMPATIBILITY_VERIFIER_ENABLED, "true"))) {
            SofaLogger.info("Skip SOFABoot compatibility Verifier");
            return;
        }
        CompositeCompatibilityVerifier compositeCompatibilityVerifier = new CompositeCompatibilityVerifier(this.getCompatibilityVerifierInstances((Environment)environment));
        compositeCompatibilityVerifier.verifyCompatibilities();
    }

    private List<CompatibilityVerifier> getCompatibilityVerifierInstances(Environment environment) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        LinkedHashSet<String> names = new LinkedHashSet<String>(SpringFactoriesLoader.loadFactoryNames(CompatibilityVerifier.class, (ClassLoader)classLoader));
        List<CompatibilityVerifier> instances = this.createSpringFactoriesInstances(CompatibilityVerifier.class, new Class[]{Environment.class}, classLoader, new Object[]{environment}, names);
        AnnotationAwareOrderComparator.sort(instances);
        return instances;
    }

    private <T> List<T> createSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, ClassLoader classLoader, Object[] args, Set<String> names) {
        ArrayList<Object> instances = new ArrayList<Object>(names.size());
        for (String name : names) {
            try {
                Class instanceClass = ClassUtils.forName((String)name, (ClassLoader)classLoader);
                Assert.isAssignable(type, (Class)instanceClass);
                Constructor constructor = instanceClass.getDeclaredConstructor(parameterTypes);
                Object instance = BeanUtils.instantiateClass(constructor, (Object[])args);
                instances.add(instance);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Cannot instantiate " + type + " : " + name, ex);
            }
        }
        return instances;
    }
}

