/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.util;

import java.beans.PropertyEditor;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.propertyeditors.ClassArrayEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.ResourceLoader;

public class SofaSpringContextUtil {
    public static DefaultListableBeanFactory createBeanFactory(ClassLoader beanClassLoader, Supplier<DefaultListableBeanFactory> beanFactoryCreator) {
        DefaultListableBeanFactory beanFactory = beanFactoryCreator.get();
        if (!(beanFactory.getAutowireCandidateResolver() instanceof QualifierAnnotationAutowireCandidateResolver)) {
            beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
        }
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new LocalVariableTableParameterNameDiscoverer());
        beanFactory.setBeanClassLoader(beanClassLoader);
        beanFactory.addPropertyEditorRegistrar(registry -> {
            registry.registerCustomEditor(Class.class, (PropertyEditor)new ClassEditor(beanClassLoader));
            registry.registerCustomEditor(Class[].class, (PropertyEditor)new ClassArrayEditor(beanClassLoader));
        });
        return beanFactory;
    }

    public static GenericApplicationContext createApplicationContext(boolean allowBeanOverriding, String contextId, ClassLoader resourceLoader, Supplier<GenericApplicationContext> contextCreator) {
        GenericApplicationContext ctx = contextCreator.get();
        ctx.setId(contextId);
        ctx.setClassLoader(resourceLoader);
        ctx.setAllowBeanDefinitionOverriding(allowBeanOverriding);
        return ctx;
    }

    public static XmlBeanDefinitionReader createBeanDefinitionReader(ClassLoader beanClassLoader, ResourceLoader resourceLoader, Supplier<XmlBeanDefinitionReader> definitionReaderCreator) {
        XmlBeanDefinitionReader beanDefinitionReader = definitionReaderCreator.get();
        beanDefinitionReader.setNamespaceAware(true);
        beanDefinitionReader.setBeanClassLoader(beanClassLoader);
        beanDefinitionReader.setResourceLoader(resourceLoader);
        return beanDefinitionReader;
    }
}

