/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.share;

import com.alipay.sofa.runtime.spring.share.SofaPostProcessorShareFilter;
import com.alipay.sofa.runtime.spring.share.UnshareSofaPostProcessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

public class SofaPostProcessorShareManager
implements ApplicationContextAware,
InitializingBean {
    private AbstractApplicationContext context;
    private List<Class> filterClassList = new CopyOnWriteArrayList<Class>();
    private List<String> filterBeanNameList = new CopyOnWriteArrayList<String>();

    public SofaPostProcessorShareManager() {
    }

    @Deprecated
    public SofaPostProcessorShareManager(AbstractApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Map map = this.context.getBeansOfType(SofaPostProcessorShareFilter.class, true, false);
        map.forEach((k, v) -> {
            this.filterClassList.addAll(v.filterBeanFactoryPostProcessorClass());
            this.filterClassList.addAll(v.filterBeanPostProcessorClass());
            this.filterBeanNameList.addAll(v.filterBeanName());
        });
    }

    public boolean unableToShare(Class<?> cls) {
        return cls != null && (this.filterClassList.contains(cls) || cls.isAnnotationPresent(UnshareSofaPostProcessor.class));
    }

    public boolean unableToShare(String beanName) {
        return this.filterBeanNameList.contains(beanName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (AbstractApplicationContext)applicationContext;
    }
}

