/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.filter;

import com.alipay.sofa.runtime.filter.JvmFilter;
import com.alipay.sofa.runtime.filter.JvmFilterContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.Ordered;

public class JvmFilterHolder {
    private static final List<JvmFilter> JVM_FILTERS = new ArrayList<JvmFilter>();
    private static final AtomicBoolean filtersSorted = new AtomicBoolean(false);
    private static final Comparator<Ordered> comparator = (f1, f2) -> Integer.compare(f1.getOrder(), f2.getOrder());

    public static void addJvmFilter(JvmFilter f) {
        JVM_FILTERS.add(f);
        filtersSorted.compareAndSet(true, false);
    }

    public static void clearJvmFilters() {
        JVM_FILTERS.clear();
    }

    private static void sortJvmFilters() {
        if (filtersSorted.compareAndSet(false, true)) {
            JVM_FILTERS.sort(comparator);
        }
    }

    public static List<JvmFilter> getJvmFilters() {
        JvmFilterHolder.sortJvmFilters();
        return JVM_FILTERS;
    }

    public static boolean beforeInvoking(JvmFilterContext context) {
        JvmFilterHolder.sortJvmFilters();
        for (JvmFilter filter : JVM_FILTERS) {
            if (filter.before(context)) continue;
            return false;
        }
        return true;
    }

    public static boolean afterInvoking(JvmFilterContext context) {
        JvmFilterHolder.sortJvmFilters();
        for (int i = JVM_FILTERS.size() - 1; i >= 0; --i) {
            if (JVM_FILTERS.get(i).after(context)) continue;
            return false;
        }
        return true;
    }
}

