/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import java.util.ArrayList;

public class Path {
    public static final String[] EMPTY_SEGMENTS = new String[0];
    public final String path;
    public String[] segments;
    public String attribute;

    public Path(String path) {
        this.path = path;
        this.parse(path);
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            return ((Path)obj).path.equals(this.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private void parse(String path) {
        int size;
        ArrayList<String> seg = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        char[] chars = path.toCharArray();
        boolean attr = false;
        block4: for (char c : chars) {
            switch (c) {
                case '/': {
                    seg.add(buf.toString());
                    buf.setLength(0);
                    continue block4;
                }
                case '@': {
                    attr = true;
                    seg.add(buf.toString());
                    buf.setLength(0);
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            if (attr) {
                this.attribute = buf.toString();
            } else {
                seg.add(buf.toString());
            }
        }
        this.segments = (size = seg.size()) == 1 && ((String)seg.get(0)).length() == 0 ? EMPTY_SEGMENTS : seg.toArray(new String[size]);
    }
}

