/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.factory;

import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.binding.JvmBindingParam;
import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.service.component.impl.ServiceImpl;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spring.factory.AbstractContractFactoryBean;

public class ServiceFactoryBean
extends AbstractContractFactoryBean {
    protected Object ref;
    protected Service service;

    public ServiceFactoryBean() {
    }

    public ServiceFactoryBean(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    @Override
    protected void doAfterPropertiesSet() {
        if (!this.apiType && this.hasSofaServiceAnnotation()) {
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-00103", (Object[])new Object[]{this.beanId, this.ref.getClass()}));
        }
        DefaultImplementation implementation = new DefaultImplementation();
        implementation.setTarget(this.ref);
        this.service = this.buildService();
        if (this.bindings.size() == 0) {
            JvmBindingParam jvmBindingParam = new JvmBindingParam().setSerialize(true);
            this.bindings.add(new JvmBinding().setJvmBindingParam(jvmBindingParam));
        }
        for (Binding binding : this.bindings) {
            this.service.addBinding(binding);
        }
        ServiceComponent componentInfo = new ServiceComponent(implementation, this.service, this.bindingAdapterFactory, this.sofaRuntimeContext);
        componentInfo.setApplicationContext(this.applicationContext);
        this.sofaRuntimeContext.getComponentManager().register(componentInfo);
    }

    private boolean hasSofaServiceAnnotation() {
        Class<?> implementationClazz = this.ref.getClass();
        SofaService sofaService = implementationClazz.getAnnotation(SofaService.class);
        if (sofaService == null) {
            return false;
        }
        String annotationUniqueId = sofaService.uniqueId();
        if ((this.uniqueId == null || this.uniqueId.isEmpty()) && (annotationUniqueId == null || annotationUniqueId.isEmpty())) {
            return true;
        }
        return annotationUniqueId.equals(this.uniqueId);
    }

    @Override
    protected void setProperties(BindingConverterContext bindingConverterContext) {
        bindingConverterContext.setBeanId(this.beanId);
    }

    protected Service buildService() {
        return new ServiceImpl(this.uniqueId, this.getInterfaceClass(), InterfaceMode.spring, this.ref);
    }

    public Object getObject() throws Exception {
        return this.service;
    }

    public Class<?> getObjectType() {
        return this.service != null ? this.service.getClass() : Service.class;
    }

    @Override
    protected boolean isInBinding() {
        return false;
    }

    public void setRef(Object ref) {
        this.ref = ref;
    }
}

