/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.boot.annotation.PlaceHolderAnnotationInvocationHandler;
import com.alipay.sofa.boot.annotation.PlaceHolderBinder;
import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.boot.util.BeanDefinitionUtil;
import com.alipay.sofa.runtime.api.annotation.SofaAsyncInit;
import com.alipay.sofa.runtime.factory.BeanLoadCostBeanFactory;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.spring.async.AsyncInitBeanHolder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.ClassUtils;

public class AsyncInitBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware,
EnvironmentAware {
    private final PlaceHolderBinder binder = new DefaultPlaceHolderBinder();
    private Environment environment;
    private String moduleName;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Arrays.stream(beanFactory.getBeanDefinitionNames()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0))).forEach((key, value) -> this.scanAsyncInitBeanDefinition((String)key, (BeanDefinition)value, beanFactory));
    }

    private void scanAsyncInitBeanDefinition(String beanId, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        if (BeanDefinitionUtil.isFromConfigurationSource((BeanDefinition)beanDefinition)) {
            this.scanAsyncInitBeanDefinitionOnMethod(beanId, (AnnotatedBeanDefinition)beanDefinition);
        } else {
            Class beanClassType = BeanDefinitionUtil.resolveBeanClassType((BeanDefinition)beanDefinition);
            if (beanClassType == null) {
                SofaLogger.warn("Bean class type cant be resolved from bean of {}", (Object)beanId);
                return;
            }
            this.scanAsyncInitBeanDefinitionOnClass(beanId, beanClassType, beanDefinition, beanFactory);
        }
    }

    private void scanAsyncInitBeanDefinitionOnMethod(String beanId, AnnotatedBeanDefinition beanDefinition) {
        Class declaringClass;
        Class returnType;
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        MethodMetadata methodMetadata = beanDefinition.getFactoryMethodMetadata();
        try {
            returnType = ClassUtils.forName((String)methodMetadata.getReturnTypeName(), null);
            declaringClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), null);
        }
        catch (Throwable throwable) {
            SofaLogger.error(ErrorCode.convert((String)"01-02001", (Object[])new Object[]{beanId}), throwable);
            return;
        }
        if (methodMetadata instanceof StandardMethodMetadata) {
            candidateMethods.add(((StandardMethodMetadata)methodMetadata).getIntrospectedMethod());
        } else {
            for (Method m : declaringClass.getDeclaredMethods()) {
                if (!m.getName().equals(methodMetadata.getMethodName()) || !m.getReturnType().getTypeName().equals(methodMetadata.getReturnTypeName()) || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, Bean.class)) continue;
                Bean bean = m.getAnnotation(Bean.class);
                HashSet<String> beanNames = new HashSet<String>();
                beanNames.add(m.getName());
                if (bean != null) {
                    beanNames.addAll(Arrays.asList(bean.name()));
                    beanNames.addAll(Arrays.asList(bean.value()));
                }
                if (!beanNames.contains(beanId)) continue;
                candidateMethods.add(m);
            }
        }
        if (candidateMethods.size() == 1) {
            SofaAsyncInit sofaAsyncInitAnnotation = ((Method)candidateMethods.get(0)).getAnnotation(SofaAsyncInit.class);
            if (sofaAsyncInitAnnotation == null) {
                sofaAsyncInitAnnotation = returnType.getAnnotation(SofaAsyncInit.class);
            }
            this.registerAsyncInitBean(beanId, sofaAsyncInitAnnotation, (BeanDefinition)beanDefinition);
        } else if (candidateMethods.size() > 1) {
            for (Method m : candidateMethods) {
                if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, SofaAsyncInit.class) && !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType, SofaAsyncInit.class)) continue;
                throw new FatalBeanException(ErrorCode.convert((String)"01-02002", (Object[])new Object[]{declaringClass.getCanonicalName()}));
            }
        }
    }

    private void scanAsyncInitBeanDefinitionOnClass(String beanId, Class<?> beanClass, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        SofaAsyncInit sofaAsyncInitAnnotation = (SofaAsyncInit)AnnotationUtils.findAnnotation(beanClass, SofaAsyncInit.class);
        this.registerAsyncInitBean(beanId, sofaAsyncInitAnnotation, beanDefinition);
    }

    private void registerAsyncInitBean(String beanId, SofaAsyncInit sofaAsyncInitAnnotation, BeanDefinition beanDefinition) {
        if (sofaAsyncInitAnnotation == null) {
            return;
        }
        PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder wrapperBuilder = PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder.wrap((Object)sofaAsyncInitAnnotation).withBinder(this.binder);
        if ((sofaAsyncInitAnnotation = (SofaAsyncInit)wrapperBuilder.build()).value()) {
            AsyncInitBeanHolder.registerAsyncInitBean(this.moduleName, beanId, beanDefinition.getInitMethodName());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.moduleName = this.getModuleName(applicationContext);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private String getModuleName(ApplicationContext applicationContext) {
        ConfigurableListableBeanFactory beanFactory = ((AbstractApplicationContext)applicationContext).getBeanFactory();
        if (beanFactory instanceof BeanLoadCostBeanFactory) {
            return ((BeanLoadCostBeanFactory)beanFactory).getId();
        }
        return "RootApplicationContext";
    }

    class DefaultPlaceHolderBinder
    implements PlaceHolderBinder {
        DefaultPlaceHolderBinder() {
        }

        public String bind(String text) {
            return AsyncInitBeanFactoryPostProcessor.this.environment.resolvePlaceholders(text);
        }
    }
}

