/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.factory;

import com.alipay.sofa.boot.startup.BaseStat;
import com.alipay.sofa.boot.startup.BeanStat;
import com.alipay.sofa.boot.startup.BeanStatExtension;
import com.alipay.sofa.runtime.spring.factory.ReferenceFactoryBean;
import com.alipay.sofa.runtime.spring.factory.ServiceFactoryBean;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.lang.Nullable;

public class BeanLoadCostBeanFactory
extends DefaultListableBeanFactory {
    private final List<BeanStat> beanStats = new ArrayList<BeanStat>();
    private long beanLoadCost;
    private String id;
    private static ThreadLocal<Stack<BeanStat>> parentStackThreadLocal = new ThreadLocal();
    private BeanStatExtension beanStatExtension;

    public BeanLoadCostBeanFactory(long beanCost, String id) {
        this.beanLoadCost = beanCost;
        this.id = id;
    }

    public BeanLoadCostBeanFactory(long beanCost, String id, BeanStatExtension beanStatExtension) {
        this.beanLoadCost = beanCost;
        this.id = id;
        this.beanStatExtension = beanStatExtension;
    }

    protected void invokeInitMethods(String beanName, Object bean, RootBeanDefinition mbd) throws Throwable {
        String initMethodName;
        boolean isInitializingBean = bean instanceof InitializingBean;
        if (isInitializingBean && (mbd == null || !mbd.isExternallyManagedInitMethod("afterPropertiesSet"))) {
            if (System.getSecurityManager() != null) {
                try {
                    AccessController.doPrivileged(() -> {
                        ((InitializingBean)bean).afterPropertiesSet();
                        return null;
                    }, this.getAccessControlContext());
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            } else {
                long start = System.currentTimeMillis();
                ((InitializingBean)bean).afterPropertiesSet();
                parentStackThreadLocal.get().peek().setAfterPropertiesSetTime(System.currentTimeMillis() - start);
            }
        }
        if (!(mbd == null || (initMethodName = mbd.getInitMethodName()) == null || isInitializingBean && "afterPropertiesSet".equals(initMethodName) || mbd.isExternallyManagedInitMethod(initMethodName))) {
            long start = System.currentTimeMillis();
            this.invokeCustomInitMethod(beanName, bean, mbd);
            parentStackThreadLocal.get().peek().setInitTime(System.currentTimeMillis() - start);
        }
    }

    protected Object createBean(String beanName, RootBeanDefinition mbd, @Nullable Object[] args) throws BeanCreationException {
        Stack<Object> parentStack = parentStackThreadLocal.get();
        BeanStat bs = new BeanStat();
        bs.setName(beanName);
        if (parentStack == null) {
            parentStack = new Stack();
            parentStackThreadLocal.set(parentStack);
        }
        if (!parentStack.empty()) {
            ((BeanStat)parentStack.peek()).addChild((BaseStat)bs);
        }
        parentStack.push(bs);
        bs.startRefresh();
        Object object = super.createBean(beanName, mbd, args);
        bs.finishRefresh();
        if (mbd.getBeanClassName() == null) {
            bs.setBeanClassName("Factory (" + mbd.getFactoryBeanName() + ")");
        } else {
            if (mbd.getBeanClassName().contains("ExtensionPointFactoryBean") || mbd.getBeanClassName().contains("ExtensionFactoryBean")) {
                bs.setExtensionProperty(object.toString());
            }
            if (object instanceof ServiceFactoryBean) {
                bs.setBeanClassName(mbd.getBeanClassName() + " (" + ((ServiceFactoryBean)object).getBeanId() + ")");
                bs.setInterfaceType(((ServiceFactoryBean)object).getInterfaceType());
            } else if (object instanceof ReferenceFactoryBean) {
                bs.setBeanClassName(mbd.getBeanClassName() + " (" + beanName + ")");
                bs.setInterfaceType(((ReferenceFactoryBean)object).getInterfaceType());
            } else {
                bs.setBeanClassName(mbd.getBeanClassName() + " (" + beanName + ")");
                if (beanName.contains(mbd.getBeanClassName())) {
                    bs.setBeanClassName(mbd.getBeanClassName());
                }
            }
        }
        if (this.beanStatExtension != null) {
            this.beanStatExtension.customBeanStat(beanName, mbd, args, bs);
        }
        parentStack.pop();
        if (parentStack.empty() && bs.getRefreshElapsedTime() > this.beanLoadCost) {
            this.beanStats.add(bs);
        }
        return object;
    }

    public List<BeanStat> getBeanStats() {
        return this.beanStats;
    }

    public String getId() {
        return this.id;
    }

    public String outputBeanStats(String indent) {
        StringBuilder rtn = new StringBuilder();
        this.beanStats.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2.getRealRefreshElapsedTime() == o1.getRealRefreshElapsedTime()) {
                return 0;
            }
            return o2.getRealRefreshElapsedTime() > o1.getRealRefreshElapsedTime() ? 1 : -1;
        });
        int size = this.beanStats.size();
        for (int i = 0; i < size; ++i) {
            rtn.append(this.beanStats.get(i).toString(indent, i == size - 1));
            rtn.append("\n");
        }
        return rtn.toString();
    }
}

