/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.initializer;

import com.alipay.sofa.infra.log.space.SofaBootLogSpaceIsolationInit;
import com.alipay.sofa.infra.utils.SOFABootEnvUtils;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class SofaRuntimeSpringContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (SOFABootEnvUtils.isSpringCloudBootstrapEnvironment((Environment)environment)) {
            return;
        }
        String runtimeLogLevelKey = "logging.level.com.alipay.sofa.runtime";
        SofaBootLogSpaceIsolationInit.initSofaBootLogger((Environment)environment, (String)runtimeLogLevelKey);
        SofaLogger.info("SOFABoot Runtime Starting!", new Object[0]);
    }
}

