/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.health;

import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.integration.invoke.DynamicJvmServiceProxyFinder;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class MultiApplicationHealthIndicator
implements HealthIndicator {
    public Health health() {
        boolean allPassed = true;
        Health.Builder builder = new Health.Builder();
        for (SofaRuntimeManager sofaRuntimeManager : SofaFramework.getRuntimeSet()) {
            if (!sofaRuntimeManager.isHealthCheckPassed()) {
                allPassed = false;
                builder.withDetail(String.format("Biz: %s health check", DynamicJvmServiceProxyFinder.getBiz(sofaRuntimeManager).getIdentity()), (Object)"failed");
                continue;
            }
            builder.withDetail(String.format("Biz: %s health check", DynamicJvmServiceProxyFinder.getBiz(sofaRuntimeManager).getIdentity()), (Object)"passed");
        }
        if (allPassed) {
            return builder.up().build();
        }
        return builder.down().build();
    }
}

