/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.factory;

import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.Reference;
import com.alipay.sofa.runtime.service.component.impl.ReferenceImpl;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spring.factory.AbstractContractFactoryBean;
import org.springframework.util.Assert;

public class ReferenceFactoryBean
extends AbstractContractFactoryBean {
    private Object proxy;
    private boolean jvmFirst = true;
    private String loadBalance;

    public ReferenceFactoryBean() {
    }

    public ReferenceFactoryBean(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    @Override
    protected void doAfterPropertiesSet() throws Exception {
        Reference reference = this.buildReference();
        Assert.isTrue((this.bindings.size() <= 1 ? 1 : 0) != 0, (String)"Found more than one binding in <sofa:reference/>, <sofa:reference/> can only have one binding.");
        if (this.bindings.size() == 0) {
            this.bindings.add(new JvmBinding());
        }
        reference.addBinding((Binding)this.bindings.get(0));
        this.proxy = ReferenceRegisterHelper.registerReference(reference, (BindingAdapterFactory)this.applicationContext.getBean("bindingAdapterFactory", BindingAdapterFactory.class), this.sofaRuntimeContext);
    }

    @Override
    protected void setProperties(BindingConverterContext bindingConverterContext) {
        bindingConverterContext.setLoadBalance(this.loadBalance);
        bindingConverterContext.setBeanId(this.beanId);
    }

    private Reference buildReference() {
        return new ReferenceImpl(this.uniqueId, this.getInterfaceClass(), InterfaceMode.spring, this.jvmFirst);
    }

    public Object getObject() throws Exception {
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.getInterfaceClass();
    }

    @Override
    protected boolean isInBinding() {
        return true;
    }

    public void setJvmFirst(boolean jvmFirst) {
        this.jvmFirst = jvmFirst;
    }

    public String getLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(String loadBalance) {
        this.loadBalance = loadBalance;
    }
}

