/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.NetworkAddressUtil;
import com.alipay.sofa.rpc.boot.common.RpcThreadPoolMonitor;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.config.UserThreadPoolManager;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.UserThreadPool;
import com.alipay.sofa.rpc.server.bolt.BoltServer;
import com.alipay.sofa.rpc.server.triple.TripleServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class ServerConfigContainer {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(ServerConfigContainer.class);
    private volatile ServerConfig boltServerConfig;
    private final Object BOLT_LOCK = new Object();
    private volatile ServerConfig restServerConfig;
    private final Object REST_LOCK = new Object();
    private volatile ServerConfig dubboServerConfig;
    private final Object DUBBO_LOCK = new Object();
    private volatile ServerConfig h2cServerConfig;
    private final Object H2C_LOCK = new Object();
    private volatile ServerConfig httpServerConfig;
    private final Object HTTP_LOCK = new Object();
    private volatile ServerConfig tripleServerConfig;
    private final Object TRIPLE_LOCK = new Object();
    private final Map<String, ServerConfig> customServerConfigs = new ConcurrentHashMap<String, ServerConfig>();
    private final RpcThreadPoolMonitor boltThreadPoolMonitor = new RpcThreadPoolMonitor("RPC-BOLT-THREADPOOL");
    private final RpcThreadPoolMonitor tripleThreadPoolMonitor = new RpcThreadPoolMonitor("RPC-TRIPLE-THREADPOOL");
    private final List<RpcThreadPoolMonitor> customThreadPoolMonitorList = new ArrayList<RpcThreadPoolMonitor>();
    private String enabledIpRange;
    private String bindNetworkInterface;
    private String boundHostStr;
    private String virtualHostStr;
    private String virtualPortStr;
    private String h2cPortStr;
    private String h2cThreadPoolCoreSizeStr;
    private String h2cThreadPoolMaxSizeStr;
    private String h2cAcceptsSizeStr;
    private String h2cThreadPoolQueueSizeStr;
    private String boltPortStr;
    private String boltThreadPoolCoreSizeStr;
    private String boltThreadPoolMaxSizeStr;
    private String boltAcceptsSizeStr;
    private String boltThreadPoolQueueSizeStr;
    private Boolean boltProcessInIoThread;
    private String restHostName;
    private String restPortStr;
    private String restIoThreadSizeStr;
    private String restContextPath;
    private String restThreadPoolMaxSizeStr;
    private String restMaxRequestSizeStr;
    private String restTelnetStr;
    private String restDaemonStr;
    private String restAllowedOrigins;
    private String dubboPortStr;
    private String dubboIoThreadSizeStr;
    private String dubboThreadPoolMaxSizeStr;
    private String dubboAcceptsSizeStr;
    private String httpPortStr;
    private String httpThreadPoolCoreSizeStr;
    private String httpThreadPoolMaxSizeStr;
    private String httpAcceptsSizeStr;
    private String httpThreadPoolQueueSizeStr;
    private String triplePortStr;
    private String tripleThreadPoolCoreSizeStr;
    private String tripleThreadPoolMaxSizeStr;
    private String tripleAcceptsSizeStr;
    private String tripleThreadPoolQueueSizeStr;

    public void startServers() {
        ThreadPoolExecutor threadPoolExecutor;
        NetworkAddressUtil.caculate(this.enabledIpRange, this.bindNetworkInterface);
        if (this.boltServerConfig != null) {
            this.boltServerConfig.buildIfAbsent().start();
            BoltServer server = (BoltServer)this.boltServerConfig.getServer();
            threadPoolExecutor = server.getBizThreadPool();
            if (threadPoolExecutor != null) {
                this.boltThreadPoolMonitor.setThreadPoolExecutor(threadPoolExecutor);
                this.boltThreadPoolMonitor.start();
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("the business threadpool can not be get");
            }
        }
        if (this.restServerConfig != null) {
            this.restServerConfig.buildIfAbsent().start();
        }
        if (this.h2cServerConfig != null) {
            this.h2cServerConfig.buildIfAbsent().start();
        }
        if (this.httpServerConfig != null) {
            this.httpServerConfig.buildIfAbsent().start();
        }
        if (this.tripleServerConfig != null) {
            this.tripleServerConfig.buildIfAbsent().start();
            TripleServer tripleServer = (TripleServer)this.tripleServerConfig.getServer();
            threadPoolExecutor = tripleServer.getBizThreadPool();
            if (threadPoolExecutor != null) {
                this.tripleThreadPoolMonitor.setThreadPoolExecutor(threadPoolExecutor);
                this.tripleThreadPoolMonitor.start();
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("the business threadpool can not be get");
            }
        }
        for (Map.Entry<String, ServerConfig> entry : this.customServerConfigs.entrySet()) {
            ServerConfig serverConfig = entry.getValue();
            if (serverConfig == null) continue;
            serverConfig.buildIfAbsent().start();
        }
        this.startCustomThreadPoolMonitor();
    }

    private void startCustomThreadPoolMonitor() {
        Set userThreadPoolSet = UserThreadPoolManager.getUserThreadPoolSet();
        if (!userThreadPoolSet.isEmpty()) {
            HashSet<String> poolNames = new HashSet<String>();
            for (UserThreadPool pool : userThreadPoolSet) {
                RpcThreadPoolMonitor customThreadPoolMonitor = new RpcThreadPoolMonitor("RPC-CUSTOM-THREADPOOL");
                this.customThreadPoolMonitorList.add(customThreadPoolMonitor);
                if (poolNames.contains(pool.getThreadPoolName())) {
                    customThreadPoolMonitor.setPoolName(pool.getThreadPoolName() + "-" + pool.hashCode());
                } else {
                    customThreadPoolMonitor.setPoolName(pool.getThreadPoolName());
                }
                customThreadPoolMonitor.setThreadPoolExecutor(pool.getExecutor());
                customThreadPoolMonitor.start();
                poolNames.add(pool.getThreadPoolName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfig getServerConfig(String protocol) {
        if (protocol.equalsIgnoreCase("bolt")) {
            if (this.boltServerConfig == null) {
                Object object = this.BOLT_LOCK;
                synchronized (object) {
                    if (this.boltServerConfig == null) {
                        this.boltServerConfig = this.createBoltServerConfig();
                    }
                }
            }
            return this.boltServerConfig;
        }
        if (protocol.equalsIgnoreCase("rest")) {
            if (this.restServerConfig == null) {
                Object object = this.REST_LOCK;
                synchronized (object) {
                    if (this.restServerConfig == null) {
                        this.restServerConfig = this.createRestServerConfig();
                    }
                }
            }
            return this.restServerConfig;
        }
        if (protocol.equalsIgnoreCase("dubbo")) {
            if (this.dubboServerConfig == null) {
                Object object = this.DUBBO_LOCK;
                synchronized (object) {
                    if (this.dubboServerConfig == null) {
                        this.dubboServerConfig = this.createDubboServerConfig();
                    }
                }
            }
            return this.dubboServerConfig;
        }
        if (protocol.equalsIgnoreCase("h2c")) {
            if (this.h2cServerConfig == null) {
                Object object = this.H2C_LOCK;
                synchronized (object) {
                    if (this.h2cServerConfig == null) {
                        this.h2cServerConfig = this.createH2cServerConfig();
                    }
                }
            }
            return this.h2cServerConfig;
        }
        if (protocol.equalsIgnoreCase("http")) {
            if (this.httpServerConfig == null) {
                Object object = this.HTTP_LOCK;
                synchronized (object) {
                    if (this.httpServerConfig == null) {
                        this.httpServerConfig = this.createHttpServerConfig();
                    }
                }
            }
            return this.httpServerConfig;
        }
        if (protocol.equalsIgnoreCase("tri")) {
            if (this.tripleServerConfig == null) {
                Object object = this.TRIPLE_LOCK;
                synchronized (object) {
                    if (this.tripleServerConfig == null) {
                        this.tripleServerConfig = this.createTripleServerConfig();
                    }
                }
            }
            return this.tripleServerConfig;
        }
        if (this.customServerConfigs.get(protocol) != null) {
            return this.customServerConfigs.get(protocol);
        }
        throw new SofaBootRpcRuntimeException(LogCodes.getLog((String)"019990027", (Object[])new Object[]{protocol}));
    }

    private void addCommonServerConfig(ServerConfig serverConfig) {
        serverConfig.setVirtualHost(NetworkAddressUtil.getLocalIP());
        serverConfig.setBoundHost(NetworkAddressUtil.getLocalBindIP());
        if (StringUtils.hasText((String)this.boundHostStr)) {
            serverConfig.setBoundHost(this.boundHostStr);
        }
        if (StringUtils.hasText((String)this.virtualHostStr)) {
            serverConfig.setVirtualHost(this.virtualHostStr);
        }
        if (StringUtils.hasText((String)this.virtualPortStr)) {
            serverConfig.setVirtualPort(Integer.valueOf(Integer.parseInt(this.virtualPortStr)));
        }
    }

    ServerConfig createH2cServerConfig() {
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)this.h2cPortStr)) {
            serverConfig.setPort(Integer.parseInt(this.h2cPortStr));
        } else {
            serverConfig.setPort(12300);
        }
        if (StringUtils.hasText((String)this.h2cThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(this.h2cThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)this.h2cThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(this.h2cThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)this.h2cAcceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(this.h2cAcceptsSizeStr));
        }
        if (StringUtils.hasText((String)this.h2cThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(this.h2cThreadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        this.addCommonServerConfig(serverConfig);
        serverConfig.setProtocol("h2c");
        return serverConfig;
    }

    public ServerConfig createBoltServerConfig() {
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)this.boltPortStr)) {
            serverConfig.setPort(Integer.parseInt(this.boltPortStr));
        } else {
            serverConfig.setPort(12200);
        }
        if (StringUtils.hasText((String)this.boltThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(this.boltThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)this.boltThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(this.boltThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)this.boltAcceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(this.boltAcceptsSizeStr));
        }
        if (StringUtils.hasText((String)this.boltThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(this.boltThreadPoolQueueSizeStr));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.boltProcessInIoThread != null) {
            parameters.put("processInIOThread", this.boltProcessInIoThread.toString());
        }
        serverConfig.setParameters(parameters);
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("bolt");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    public ServerConfig createRestServerConfig() {
        if (!StringUtils.hasText((String)this.restHostName)) {
            this.restHostName = null;
        }
        int port = !StringUtils.hasText((String)this.restPortStr) ? 8341 : Integer.parseInt(this.restPortStr);
        int ioThreadCount = !StringUtils.hasText((String)this.restIoThreadSizeStr) ? SofaBootRpcConfigConstants.REST_IO_THREAD_COUNT_DEFAULT : Integer.parseInt(this.restIoThreadSizeStr);
        int restThreadPoolMaxSize = !StringUtils.hasText((String)this.restThreadPoolMaxSizeStr) ? 200 : Integer.parseInt(this.restThreadPoolMaxSizeStr);
        int maxRequestSize = !StringUtils.hasText((String)this.restMaxRequestSizeStr) ? 0xA00000 : Integer.parseInt(this.restMaxRequestSizeStr);
        boolean telnet = !StringUtils.hasText((String)this.restTelnetStr) ? true : Boolean.parseBoolean(this.restTelnetStr);
        boolean daemon = !StringUtils.hasText((String)this.restDaemonStr) ? true : Boolean.parseBoolean(this.restDaemonStr);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.hasText((String)this.restAllowedOrigins)) {
            parameters.put("allowedOrigins", this.restAllowedOrigins);
        }
        ServerConfig serverConfig = new ServerConfig().setPort(port).setIoThreads(ioThreadCount).setMaxThreads(restThreadPoolMaxSize).setPayload(maxRequestSize).setTelnet(telnet).setDaemon(daemon).setParameters(parameters);
        if (!StringUtils.isEmpty((Object)this.restContextPath)) {
            serverConfig.setContextPath(this.restContextPath);
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("rest");
        this.addCommonServerConfig(serverConfig);
        serverConfig.setBoundHost(this.restHostName);
        return serverConfig;
    }

    public ServerConfig createDubboServerConfig() {
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)this.dubboPortStr)) {
            serverConfig.setPort(Integer.parseInt(this.dubboPortStr));
        } else {
            serverConfig.setPort(20880);
        }
        if (StringUtils.hasText((String)this.dubboIoThreadSizeStr)) {
            serverConfig.setIoThreads(Integer.parseInt(this.dubboIoThreadSizeStr));
        }
        if (StringUtils.hasText((String)this.dubboThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(this.dubboThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)this.dubboAcceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(this.dubboAcceptsSizeStr));
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("dubbo");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    ServerConfig createHttpServerConfig() {
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)this.httpPortStr)) {
            serverConfig.setPort(Integer.parseInt(this.httpPortStr));
        } else {
            serverConfig.setPort(12400);
        }
        if (StringUtils.hasText((String)this.httpThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(this.httpThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)this.httpThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(this.httpThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)this.httpAcceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(this.httpAcceptsSizeStr));
        }
        if (StringUtils.hasText((String)this.httpThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(this.httpThreadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        this.addCommonServerConfig(serverConfig);
        serverConfig.setProtocol("http");
        return serverConfig;
    }

    private ServerConfig createTripleServerConfig() {
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)this.triplePortStr)) {
            serverConfig.setPort(Integer.parseInt(this.triplePortStr));
        } else {
            serverConfig.setPort(50051);
        }
        if (StringUtils.hasText((String)this.tripleThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(this.tripleThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)this.tripleThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(this.tripleThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)this.tripleAcceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(this.tripleAcceptsSizeStr));
        }
        if (StringUtils.hasText((String)this.tripleThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(this.tripleThreadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("tri");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    public void closeAllServer() {
        if (this.boltThreadPoolMonitor != null) {
            this.boltThreadPoolMonitor.stop();
        }
        if (this.tripleThreadPoolMonitor != null) {
            this.tripleThreadPoolMonitor.stop();
        }
        this.stopCustomThreadPoolMonitor();
        this.destroyServerConfig(this.boltServerConfig);
        this.destroyServerConfig(this.restServerConfig);
        this.destroyServerConfig(this.dubboServerConfig);
        this.destroyServerConfig(this.h2cServerConfig);
        this.destroyServerConfig(this.tripleServerConfig);
        for (Map.Entry<String, ServerConfig> entry : this.customServerConfigs.entrySet()) {
            ServerConfig serverConfig = entry.getValue();
            this.destroyServerConfig(serverConfig);
        }
        this.boltServerConfig = null;
        this.restServerConfig = null;
        this.dubboServerConfig = null;
        this.h2cServerConfig = null;
        this.tripleServerConfig = null;
        this.customServerConfigs.clear();
    }

    private void stopCustomThreadPoolMonitor() {
        if (!this.customThreadPoolMonitorList.isEmpty()) {
            for (RpcThreadPoolMonitor monitor : this.customThreadPoolMonitorList) {
                monitor.stop();
            }
            this.customThreadPoolMonitorList.clear();
        }
    }

    private void destroyServerConfig(ServerConfig serverConfig) {
        Server server;
        if (serverConfig != null && (server = serverConfig.getServer()) != null && server.hasNoEntry()) {
            serverConfig.destroy();
        }
    }

    public boolean registerCustomServerConfig(String protocol, ServerConfig serverConfig) {
        if (this.customServerConfigs.containsKey(protocol)) {
            return false;
        }
        this.customServerConfigs.put(protocol, serverConfig);
        return true;
    }

    public boolean unRegisterCustomServerConfig(String protocol) {
        this.customServerConfigs.remove(protocol);
        return true;
    }

    public void setBoundHostStr(String boundHostStr) {
        this.boundHostStr = boundHostStr;
    }

    public void setVirtualHostStr(String virtualHostStr) {
        this.virtualHostStr = virtualHostStr;
    }

    public void setVirtualPortStr(String virtualPortStr) {
        this.virtualPortStr = virtualPortStr;
    }

    public void setH2cPortStr(String h2cPortStr) {
        this.h2cPortStr = h2cPortStr;
    }

    public void setH2cThreadPoolCoreSizeStr(String h2cThreadPoolCoreSizeStr) {
        this.h2cThreadPoolCoreSizeStr = h2cThreadPoolCoreSizeStr;
    }

    public void setH2cThreadPoolMaxSizeStr(String h2cThreadPoolMaxSizeStr) {
        this.h2cThreadPoolMaxSizeStr = h2cThreadPoolMaxSizeStr;
    }

    public void setH2cAcceptsSizeStr(String h2cAcceptsSizeStr) {
        this.h2cAcceptsSizeStr = h2cAcceptsSizeStr;
    }

    public void setH2cThreadPoolQueueSizeStr(String h2cThreadPoolQueueSizeStr) {
        this.h2cThreadPoolQueueSizeStr = h2cThreadPoolQueueSizeStr;
    }

    public void setBoltPortStr(String boltPortStr) {
        this.boltPortStr = boltPortStr;
    }

    public void setBoltThreadPoolCoreSizeStr(String boltThreadPoolCoreSizeStr) {
        this.boltThreadPoolCoreSizeStr = boltThreadPoolCoreSizeStr;
    }

    public void setBoltThreadPoolMaxSizeStr(String boltThreadPoolMaxSizeStr) {
        this.boltThreadPoolMaxSizeStr = boltThreadPoolMaxSizeStr;
    }

    public void setBoltAcceptsSizeStr(String boltAcceptsSizeStr) {
        this.boltAcceptsSizeStr = boltAcceptsSizeStr;
    }

    public void setBoltThreadPoolQueueSizeStr(String boltThreadPoolQueueSizeStr) {
        this.boltThreadPoolQueueSizeStr = boltThreadPoolQueueSizeStr;
    }

    public void setBoltProcessInIoThread(Boolean boltProcessInIoThread) {
        this.boltProcessInIoThread = boltProcessInIoThread;
    }

    public void setRestHostName(String restHostName) {
        this.restHostName = restHostName;
    }

    public void setRestPortStr(String restPortStr) {
        this.restPortStr = restPortStr;
    }

    public void setRestIoThreadSizeStr(String restIoThreadSizeStr) {
        this.restIoThreadSizeStr = restIoThreadSizeStr;
    }

    public void setRestContextPath(String restContextPath) {
        this.restContextPath = restContextPath;
    }

    public void setRestThreadPoolMaxSizeStr(String restThreadPoolMaxSizeStr) {
        this.restThreadPoolMaxSizeStr = restThreadPoolMaxSizeStr;
    }

    public void setRestMaxRequestSizeStr(String restMaxRequestSizeStr) {
        this.restMaxRequestSizeStr = restMaxRequestSizeStr;
    }

    public void setRestTelnetStr(String restTelnetStr) {
        this.restTelnetStr = restTelnetStr;
    }

    public void setRestDaemonStr(String restDaemonStr) {
        this.restDaemonStr = restDaemonStr;
    }

    public void setRestAllowedOrigins(String restAllowedOrigins) {
        this.restAllowedOrigins = restAllowedOrigins;
    }

    public void setDubboPortStr(String dubboPortStr) {
        this.dubboPortStr = dubboPortStr;
    }

    public void setDubboIoThreadSizeStr(String dubboIoThreadSizeStr) {
        this.dubboIoThreadSizeStr = dubboIoThreadSizeStr;
    }

    public void setDubboThreadPoolMaxSizeStr(String dubboThreadPoolMaxSizeStr) {
        this.dubboThreadPoolMaxSizeStr = dubboThreadPoolMaxSizeStr;
    }

    public void setDubboAcceptsSizeStr(String dubboAcceptsSizeStr) {
        this.dubboAcceptsSizeStr = dubboAcceptsSizeStr;
    }

    public void setHttpPortStr(String httpPortStr) {
        this.httpPortStr = httpPortStr;
    }

    public void setHttpThreadPoolCoreSizeStr(String httpThreadPoolCoreSizeStr) {
        this.httpThreadPoolCoreSizeStr = httpThreadPoolCoreSizeStr;
    }

    public void setHttpThreadPoolMaxSizeStr(String httpThreadPoolMaxSizeStr) {
        this.httpThreadPoolMaxSizeStr = httpThreadPoolMaxSizeStr;
    }

    public void setHttpAcceptsSizeStr(String httpAcceptsSizeStr) {
        this.httpAcceptsSizeStr = httpAcceptsSizeStr;
    }

    public void setHttpThreadPoolQueueSizeStr(String httpThreadPoolQueueSizeStr) {
        this.httpThreadPoolQueueSizeStr = httpThreadPoolQueueSizeStr;
    }

    public void setTriplePortStr(String triplePortStr) {
        this.triplePortStr = triplePortStr;
    }

    public void setTripleThreadPoolCoreSizeStr(String tripleThreadPoolCoreSizeStr) {
        this.tripleThreadPoolCoreSizeStr = tripleThreadPoolCoreSizeStr;
    }

    public void setTripleThreadPoolMaxSizeStr(String tripleThreadPoolMaxSizeStr) {
        this.tripleThreadPoolMaxSizeStr = tripleThreadPoolMaxSizeStr;
    }

    public void setTripleAcceptsSizeStr(String tripleAcceptsSizeStr) {
        this.tripleAcceptsSizeStr = tripleAcceptsSizeStr;
    }

    public void setTripleThreadPoolQueueSizeStr(String tripleThreadPoolQueueSizeStr) {
        this.tripleThreadPoolQueueSizeStr = tripleThreadPoolQueueSizeStr;
    }

    public void setEnabledIpRange(String enabledIpRange) {
        this.enabledIpRange = enabledIpRange;
    }

    public void setBindNetworkInterface(String bindNetworkInterface) {
        this.bindNetworkInterface = bindNetworkInterface;
    }
}

