/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.RegistryConfigureProcessor;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigKeys;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.log.LogCodes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RegistryConfigContainer {
    private static final String DEFAULT_REGISTRY = "DEFAULT";
    private Map<String, RegistryConfigureProcessor> registryConfigMap;
    private final Map<String, RegistryConfig> registryConfigs = new ConcurrentHashMap<String, RegistryConfig>();
    private final String customDefaultRegistry;
    private String customDefaultRegistryAddress;
    private Map<String, String> registries = new HashMap<String, String>();
    private String defaultRegistryAddress;
    private String meshConfig;
    private boolean ignoreRegistry;

    public RegistryConfigContainer(Map<String, RegistryConfigureProcessor> registryConfigMap) {
        this.registryConfigMap = registryConfigMap;
        this.customDefaultRegistry = (String)SofaConfigs.getOrDefault(SofaBootRpcConfigKeys.DEFAULT_REGISTRY);
        if (StringUtils.isNotBlank((CharSequence)this.customDefaultRegistry)) {
            this.customDefaultRegistryAddress = System.getProperty(this.customDefaultRegistry);
        }
    }

    public RegistryConfig getRegistryConfig(String registryAlias) throws SofaBootRpcRuntimeException {
        int endIndex;
        String currentDefaultAlias = StringUtils.isNotBlank((CharSequence)this.customDefaultRegistry) ? this.customDefaultRegistry : DEFAULT_REGISTRY;
        if (StringUtils.isEmpty((CharSequence)registryAlias)) {
            registryAlias = currentDefaultAlias;
        }
        if (this.registryConfigs.get(registryAlias) != null) {
            return this.registryConfigs.get(registryAlias);
        }
        String registryAddress = DEFAULT_REGISTRY.equalsIgnoreCase(registryAlias) ? this.defaultRegistryAddress : (registryAlias.equals(this.customDefaultRegistry) ? this.customDefaultRegistryAddress : this.registries.get(registryAlias));
        String registryProtocol = StringUtils.isBlank((CharSequence)registryAddress) ? "local" : ((endIndex = registryAddress.indexOf("://")) != -1 ? registryAddress.substring(0, endIndex) : registryAlias);
        if (this.registryConfigMap.get(registryProtocol) != null) {
            RegistryConfigureProcessor registryConfigureProcessor = this.registryConfigMap.get(registryProtocol);
            RegistryConfig registryConfig = registryConfigureProcessor.buildFromAddress(registryAddress);
            this.registryConfigs.put(registryAlias, registryConfig);
            if (this.ignoreRegistry) {
                registryConfig.setRegister(false);
            }
            return registryConfig;
        }
        throw new SofaBootRpcRuntimeException(LogCodes.getLog((String)"010060028", (Object[])new Object[]{registryAddress}));
    }

    public RegistryConfig getRegistryConfig() throws SofaBootRpcRuntimeException {
        if (StringUtils.isNotBlank((CharSequence)this.customDefaultRegistry)) {
            return this.getRegistryConfig(this.customDefaultRegistry);
        }
        return this.getRegistryConfig(DEFAULT_REGISTRY);
    }

    public void removeAllRegistryConfig() {
        this.registryConfigMap.clear();
    }

    public Map<String, RegistryConfigureProcessor> getRegistryConfigMap() {
        return this.registryConfigMap;
    }

    public void setRegistryConfigMap(Map<String, RegistryConfigureProcessor> registryConfigMap) {
        this.registryConfigMap = registryConfigMap;
    }

    public Map<String, RegistryConfig> getRegistryConfigs() {
        return this.registryConfigs;
    }

    public boolean isMeshEnabled(String protocol) {
        if (StringUtils.isNotBlank((CharSequence)this.meshConfig) && this.registries != null && this.registries.get("mesh") != null) {
            if (this.meshConfig.equalsIgnoreCase("all")) {
                return true;
            }
            List<String> meshEnableProtocols = Arrays.asList(this.meshConfig.split(","));
            for (String meshProtocol : meshEnableProtocols) {
                if (!StringUtils.equals((CharSequence)meshProtocol, (CharSequence)protocol)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void setRegistries(Map<String, String> registries) {
        this.registries = registries;
    }

    public void setDefaultRegistryAddress(String defaultRegistryAddress) {
        this.defaultRegistryAddress = defaultRegistryAddress;
    }

    public void setMeshConfig(String meshConfig) {
        this.meshConfig = meshConfig;
    }

    public void setIgnoreRegistry(boolean ignoreRegistry) {
        this.ignoreRegistry = ignoreRegistry;
    }
}

