/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.alipay.sofa.runtime.spi.binding.Contract;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ProviderConfigContainer {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(ProviderConfigContainer.class);
    private boolean allowPublish = false;
    private List<String> providerRegisterWhiteList;
    private List<String> providerRegisterBlackList;
    private final ConcurrentMap<String, ProviderConfig> RPC_SERVICE_CONTAINER = new ConcurrentHashMap<String, ProviderConfig>(256);

    public void addProviderConfig(String key, ProviderConfig providerConfig) {
        if (providerConfig != null) {
            if (this.RPC_SERVICE_CONTAINER.containsKey(key)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("The same services and protocols already exist.key[" + key + "];protocol[" + providerConfig.getServer().get(0) + "]");
                }
            } else {
                this.RPC_SERVICE_CONTAINER.put(key, providerConfig);
            }
        }
    }

    private boolean allowProviderRegister(ProviderConfig providerConfig) {
        if (CollectionUtils.isEmpty(this.providerRegisterWhiteList) && CollectionUtils.isEmpty(this.providerRegisterBlackList)) {
            return true;
        }
        String uniqueName = this.createUniqueNameByProvider(providerConfig);
        if (!CollectionUtils.isEmpty(this.providerRegisterBlackList) && this.providerRegisterBlackList.contains(uniqueName)) {
            return false;
        }
        return CollectionUtils.isEmpty(this.providerRegisterWhiteList) || this.providerRegisterWhiteList.contains(uniqueName);
    }

    public ProviderConfig getProviderConfig(String key) {
        return (ProviderConfig)this.RPC_SERVICE_CONTAINER.get(key);
    }

    public void removeProviderConfig(String key) {
        this.RPC_SERVICE_CONTAINER.remove(key);
    }

    public Collection<ProviderConfig> getAllProviderConfig() {
        return this.RPC_SERVICE_CONTAINER.values();
    }

    public void publishAllProviderConfig() {
        for (ProviderConfig providerConfig : this.getAllProviderConfig()) {
            ServerConfig serverConfig = (ServerConfig)providerConfig.getServer().get(0);
            if (serverConfig.getProtocol().equalsIgnoreCase("dubbo")) continue;
            if (this.allowProviderRegister(providerConfig)) {
                providerConfig.setRegister(true);
            } else {
                LOGGER.info("Provider will not register: [{}]", (Object)providerConfig.buildKey());
            }
            List registrys = providerConfig.getRegistry();
            for (RegistryConfig registryConfig : registrys) {
                Registry registry = RegistryFactory.getRegistry((RegistryConfig)registryConfig);
                registry.init();
                registry.start();
                registry.register(providerConfig);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("service published.  interfaceId[" + providerConfig.getInterfaceId() + "]; protocol[" + serverConfig.getProtocol() + "]");
            }
        }
    }

    public void exportAllDubboProvideConfig() {
        for (ProviderConfig providerConfig : this.getAllProviderConfig()) {
            ServerConfig serverConfig = (ServerConfig)providerConfig.getServer().get(0);
            if (!serverConfig.getProtocol().equalsIgnoreCase("dubbo")) continue;
            providerConfig.setRegister(true);
            providerConfig.export();
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("service published.  interfaceId[" + providerConfig.getInterfaceId() + "]; protocol[" + serverConfig.getProtocol() + "]");
        }
    }

    public void unExportAllProviderConfig() {
        for (ProviderConfig providerConfig : this.getAllProviderConfig()) {
            providerConfig.unExport();
        }
    }

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setAllowPublish(boolean allowPublish) {
        this.allowPublish = allowPublish;
    }

    public String createUniqueName(Contract contract, RpcBinding binding) {
        Object uniqueId = "";
        Object version = ":1.0";
        Object protocol = "";
        if (StringUtils.hasText((String)contract.getUniqueId())) {
            uniqueId = ":" + contract.getUniqueId();
        }
        if (StringUtils.hasText((String)contract.getProperty("version"))) {
            version = ":" + contract.getProperty("version");
        }
        if (StringUtils.hasText((String)binding.getBindingType().getType())) {
            protocol = ":" + binding.getBindingType().getType();
        }
        return contract.getInterfaceType().getName() + (String)version + (String)uniqueId + (String)protocol;
    }

    private String createUniqueNameByProvider(ProviderConfig providerConfig) {
        Object uniqueId = "";
        if (StringUtils.hasText((String)providerConfig.getUniqueId())) {
            uniqueId = ":" + providerConfig.getUniqueId();
        }
        return providerConfig.getInterfaceId() + (String)uniqueId;
    }

    public void setProviderRegisterWhiteList(List<String> providerRegisterWhiteList) {
        this.providerRegisterWhiteList = providerRegisterWhiteList;
    }

    public void setProviderRegisterBlackList(List<String> providerRegisterBlackList) {
        this.providerRegisterBlackList = providerRegisterBlackList;
    }

    public List<String> getProviderRegisterWhiteList() {
        return this.providerRegisterWhiteList;
    }

    public List<String> getProviderRegisterBlackList() {
        return this.providerRegisterBlackList;
    }
}

