/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcParserUtil;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfig;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;

public class FaultToleranceConfigurator {
    private String appName;
    private String regulationEffectiveStr;
    private String degradeEffectiveStr;
    private String timeWindowStr;
    private String leastWindowCountStr;
    private String leastWindowExceptionRateMultipleStr;
    private String weightDegradeRateStr;
    private String weightRecoverRateStr;
    private String degradeLeastWeightStr;
    private String degradeMaxIpCountStr;

    public void startFaultTolerance() {
        Boolean regulationEffective = SofaBootRpcParserUtil.parseBoolean(this.regulationEffectiveStr);
        Boolean degradeEffective = SofaBootRpcParserUtil.parseBoolean(this.degradeEffectiveStr);
        Long timeWindow = SofaBootRpcParserUtil.parseLong(this.timeWindowStr);
        Long leastWindowCount = SofaBootRpcParserUtil.parseLong(this.leastWindowCountStr);
        Double leastWindowExceptionRateMultiple = SofaBootRpcParserUtil.parseDouble(this.leastWindowExceptionRateMultipleStr);
        Double weightDegradeRate = SofaBootRpcParserUtil.parseDouble(this.weightDegradeRateStr);
        Double weightRecoverRate = SofaBootRpcParserUtil.parseDouble(this.weightRecoverRateStr);
        Integer degradeLeastWeight = SofaBootRpcParserUtil.parseInteger(this.degradeLeastWeightStr);
        Integer degradeMaxIpCount = SofaBootRpcParserUtil.parseInteger(this.degradeMaxIpCountStr);
        FaultToleranceConfig faultToleranceConfig = new FaultToleranceConfig();
        if (regulationEffective != null) {
            faultToleranceConfig.setRegulationEffective(regulationEffective.booleanValue());
        }
        if (degradeEffective != null) {
            faultToleranceConfig.setDegradeEffective(degradeEffective.booleanValue());
        }
        if (timeWindow != null) {
            faultToleranceConfig.setTimeWindow(timeWindow.longValue());
        }
        if (leastWindowCount != null) {
            faultToleranceConfig.setLeastWindowCount(leastWindowCount.longValue());
        }
        if (leastWindowExceptionRateMultiple != null) {
            faultToleranceConfig.setLeastWindowExceptionRateMultiple(leastWindowExceptionRateMultiple.doubleValue());
        }
        if (weightDegradeRate != null) {
            faultToleranceConfig.setWeightDegradeRate(weightDegradeRate.doubleValue());
        }
        if (weightRecoverRate != null) {
            faultToleranceConfig.setWeightRecoverRate(weightRecoverRate.doubleValue());
        }
        if (degradeLeastWeight != null) {
            faultToleranceConfig.setDegradeLeastWeight(degradeLeastWeight.intValue());
        }
        if (degradeMaxIpCount != null) {
            faultToleranceConfig.setDegradeMaxIpCount(degradeMaxIpCount.intValue());
        }
        FaultToleranceConfigManager.putAppConfig((String)this.appName, (FaultToleranceConfig)faultToleranceConfig);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setRegulationEffectiveStr(String regulationEffectiveStr) {
        this.regulationEffectiveStr = regulationEffectiveStr;
    }

    public void setDegradeEffectiveStr(String degradeEffectiveStr) {
        this.degradeEffectiveStr = degradeEffectiveStr;
    }

    public void setTimeWindowStr(String timeWindowStr) {
        this.timeWindowStr = timeWindowStr;
    }

    public void setLeastWindowCountStr(String leastWindowCountStr) {
        this.leastWindowCountStr = leastWindowCountStr;
    }

    public void setLeastWindowExceptionRateMultipleStr(String leastWindowExceptionRateMultipleStr) {
        this.leastWindowExceptionRateMultipleStr = leastWindowExceptionRateMultipleStr;
    }

    public void setWeightDegradeRateStr(String weightDegradeRateStr) {
        this.weightDegradeRateStr = weightDegradeRateStr;
    }

    public void setWeightRecoverRateStr(String weightRecoverRateStr) {
        this.weightRecoverRateStr = weightRecoverRateStr;
    }

    public void setDegradeLeastWeightStr(String degradeLeastWeightStr) {
        this.degradeLeastWeightStr = degradeLeastWeightStr;
    }

    public void setDegradeMaxIpCountStr(String degradeMaxIpCountStr) {
        this.degradeMaxIpCountStr = degradeMaxIpCountStr;
    }
}

