/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.common;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NetworkAddressUtil {
    private static final char COLON = ':';
    protected static List<IpRange> IP_RANGES = null;
    private static String NETWORK_ADDRESS;
    private static String BIND_NETWORK_ADDRESS;
    private static String HOST_NAME;
    private static String DEFAULT_HOST_NAME;

    public static void caculate(String enabledIpRange, String bindNetworkInterface) {
        IP_RANGES = new CopyOnWriteArrayList<IpRange>();
        if (StringUtils.isEmpty((CharSequence)enabledIpRange)) {
            IP_RANGES.add(new IpRange("0", "255"));
            BIND_NETWORK_ADDRESS = "0.0.0.0";
        } else {
            String[] ipRanges;
            for (String ipRange : ipRanges = enabledIpRange.split(",")) {
                if (StringUtils.isEmpty((CharSequence)ipRange)) continue;
                if (ipRange.indexOf(58) > -1) {
                    String[] ranges = ipRange.split(":");
                    IP_RANGES.add(new IpRange(ranges[0], ranges[1]));
                    continue;
                }
                IP_RANGES.add(new IpRange(ipRange));
            }
        }
        NETWORK_ADDRESS = NetworkAddressUtil.getNetworkAddress(bindNetworkInterface);
        HOST_NAME = NetworkAddressUtil.getHostName();
    }

    public static String getNetworkAddress(String bindNetworkInterface) {
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                boolean useNi = false;
                NetworkInterface ni = netInterfaces.nextElement();
                if (!StringUtils.isBlank((CharSequence)bindNetworkInterface)) {
                    if (!bindNetworkInterface.equals(ni.getDisplayName()) && !bindNetworkInterface.equals(ni.getName())) continue;
                    useNi = true;
                }
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip.isLoopbackAddress() || ip.getHostAddress().indexOf(58) != -1 || !useNi && !NetworkAddressUtil.ipEnabled(ip.getHostAddress())) continue;
                    return ip.getHostAddress();
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getLocalIP() {
        return NETWORK_ADDRESS;
    }

    public static String getLocalBindIP() {
        if (BIND_NETWORK_ADDRESS != null) {
            return BIND_NETWORK_ADDRESS;
        }
        return NETWORK_ADDRESS;
    }

    public static String getLocalHostName() {
        return HOST_NAME;
    }

    private static String getHostName() {
        String hostName = DEFAULT_HOST_NAME;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = DEFAULT_HOST_NAME;
        }
        return hostName;
    }

    public static boolean ipEnabled(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        if (IP_RANGES.isEmpty()) {
            return true;
        }
        for (IpRange ipRange : IP_RANGES) {
            if (!ipRange.isEnabled(ip)) continue;
            return true;
        }
        return false;
    }

    static {
        BIND_NETWORK_ADDRESS = null;
        DEFAULT_HOST_NAME = "app";
    }

    protected static class IpRange {
        private long start;
        private long end;

        public IpRange(String ip) {
            this.start = this.parseStart(ip);
            this.end = this.parseEnd(ip);
        }

        public IpRange(String startIp, String endIp) {
            this.start = this.parseStart(startIp);
            this.end = this.parseEnd(endIp);
        }

        private long parseStart(String ip) {
            int[] starts = new int[]{0, 0, 0, 0};
            return this.parse(starts, ip);
        }

        private long parseEnd(String ip) {
            int[] ends = new int[]{255, 255, 255, 255};
            return this.parse(ends, ip);
        }

        private long parse(int[] segments, String ip) {
            String[] ipSegments = ip.split("\\.");
            for (int i = 0; i < ipSegments.length; ++i) {
                segments[i] = Integer.parseInt(ipSegments[i]);
            }
            long ret = 0L;
            for (int i : segments) {
                ret += ret * 255L + (long)i;
            }
            return ret;
        }

        public boolean isEnabled(String ip) {
            String[] ipSegments = ip.split("\\.");
            long ipInt = 0L;
            for (String ipSegment : ipSegments) {
                ipInt += ipInt * 255L + (long)Integer.parseInt(ipSegment);
            }
            return ipInt >= this.start && ipInt <= this.end;
        }
    }
}

