/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.converter;

import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBindingType;
import com.alipay.sofa.rpc.boot.runtime.binding.TripleBinding;
import com.alipay.sofa.rpc.boot.runtime.converter.RpcBindingConverter;
import com.alipay.sofa.rpc.boot.runtime.param.RpcBindingParam;
import com.alipay.sofa.rpc.boot.runtime.param.TripleBindingParam;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.annotation.SofaReferenceBinding;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Element;

public class TripleBindingConverter
extends RpcBindingConverter {
    @Override
    protected RpcBinding createRpcBinding(RpcBindingParam bindingParam, ApplicationContext applicationContext, boolean inBinding) {
        return new TripleBinding(bindingParam, applicationContext, inBinding);
    }

    @Override
    protected RpcBindingParam createRpcBindingParam() {
        return new TripleBindingParam();
    }

    @Override
    public RpcBinding convert(SofaService sofaServiceAnnotation, SofaServiceBinding sofaServiceBindingAnnotation, BindingConverterContext bindingConverterContext) {
        TripleBindingParam bindingParam = new TripleBindingParam();
        this.convertServiceAnnotation(bindingParam, sofaServiceAnnotation, sofaServiceBindingAnnotation, bindingConverterContext);
        return new TripleBinding(bindingParam, bindingConverterContext.getApplicationContext(), bindingConverterContext.isInBinding());
    }

    @Override
    public RpcBinding convert(SofaReference sofaReferenceAnnotation, SofaReferenceBinding sofaReferenceBindingAnnotation, BindingConverterContext bindingConverterContext) {
        TripleBindingParam bindingParam = new TripleBindingParam();
        this.convertReferenceAnnotation(bindingParam, sofaReferenceBindingAnnotation, bindingConverterContext);
        return new TripleBinding(bindingParam, bindingConverterContext.getApplicationContext(), bindingConverterContext.isInBinding());
    }

    @Override
    protected void parseGlobalAttrs(Element element, RpcBindingParam param, BindingConverterContext bindingConverterContext) {
        super.parseGlobalAttrs(element, param, bindingConverterContext);
        if (element == null) {
            param.setSerialization("protobuf");
        } else {
            String serialization = element.getAttribute("serialize-type");
            if (StringUtils.isBlank((CharSequence)serialization)) {
                param.setSerialization("protobuf");
            }
        }
    }

    public BindingType supportBindingType() {
        return RpcBindingType.TRIPLE_BINDING_TYPE;
    }

    public String supportTagName() {
        return "binding.tri";
    }
}

