/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.binding;

import com.alipay.sofa.rpc.boot.runtime.param.RpcBindingParam;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.runtime.spi.binding.AbstractBinding;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Element;

public abstract class RpcBinding
extends AbstractBinding {
    protected String appName;
    protected String beanId;
    protected RpcBindingParam rpcBindingParam;
    protected ApplicationContext applicationContext;
    protected boolean inBinding;
    protected ConsumerConfig consumerConfig;

    public RpcBinding(RpcBindingParam bindingParam, ApplicationContext applicationContext, boolean inBinding) {
        this.rpcBindingParam = bindingParam;
        this.applicationContext = applicationContext;
        this.inBinding = inBinding;
    }

    public String getBootStrap() {
        String bindingType = this.getBindingType().getType();
        if (bindingType.equalsIgnoreCase("dubbo")) {
            return "dubbo";
        }
        return "bolt";
    }

    public String getURI() {
        return null;
    }

    public Element getBindingPropertyContent() {
        return null;
    }

    public int getBindingHashCode() {
        return this.hashCode();
    }

    public HealthResult healthCheck() {
        HealthResult result = new HealthResult(this.getName());
        if (this.inBinding && this.consumerConfig != null) {
            if (this.consumerConfig.getConsumerBootstrap().isSubscribed()) {
                result.setHealthy(true);
            } else if (this.getRpcBindingParam().isHealthyDestine(this.getAppName())) {
                result.setHealthy(true);
            } else {
                result.setHealthy(false);
                result.setHealthReport("Addresses unavailable");
            }
        } else {
            result.setHealthy(this.isHealthy);
        }
        return result;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public RpcBindingParam getRpcBindingParam() {
        return this.rpcBindingParam;
    }

    public void setRpcBindingParam(RpcBindingParam rpcBindingParam) {
        this.rpcBindingParam = rpcBindingParam;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean isInBinding() {
        return this.inBinding;
    }

    public void setInBinding(boolean inBinding) {
        this.inBinding = inBinding;
    }

    public ConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    public void setConsumerConfig(ConsumerConfig consumerConfig) {
        this.consumerConfig = consumerConfig;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RpcBinding that = (RpcBinding)((Object)object);
        if (this.inBinding != that.inBinding) {
            return false;
        }
        if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) {
            return false;
        }
        if (this.beanId != null ? !this.beanId.equals(that.beanId) : that.beanId != null) {
            return false;
        }
        if (this.rpcBindingParam != null ? !this.rpcBindingParam.equals(that.rpcBindingParam) : that.rpcBindingParam != null) {
            return false;
        }
        if (this.applicationContext != null ? !this.applicationContext.equals(that.applicationContext) : that.applicationContext != null) {
            return false;
        }
        return this.consumerConfig != null ? this.consumerConfig.equals(that.consumerConfig) : that.consumerConfig == null;
    }

    public int hashCode() {
        int result = this.appName != null ? this.appName.hashCode() : 0;
        result = 31 * result + (this.beanId != null ? this.beanId.hashCode() : 0);
        result = 31 * result + (this.rpcBindingParam != null ? this.rpcBindingParam.hashCode() : 0);
        result = 31 * result + (this.applicationContext != null ? this.applicationContext.hashCode() : 0);
        result = 31 * result + (this.inBinding ? 1 : 0);
        result = 31 * result + (this.consumerConfig != null ? this.consumerConfig.hashCode() : 0);
        return result;
    }
}

