/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.RemotingException;

public abstract class AbstractServerHandler<T>
implements ChannelHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SESSION-CONNECT");

    public void connected(Channel channel) throws RemotingException {
        if (channel != null && channel.isConnected()) {
            LOGGER.info(this.getConnectNodeType() + " node connected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
    }

    public void disconnected(Channel channel) throws RemotingException {
        if (channel != null && !channel.isConnected()) {
            LOGGER.info(this.getConnectNodeType() + " node disconnected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
    }

    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.CLIENT;
    }

    public void caught(Channel channel, T message, Throwable exception) {
    }

    public void received(Channel channel, T message) {
    }

    public Object reply(Channel channel, T message) throws RemotingException {
        return null;
    }

    public Class interest() {
        return null;
    }
}

