/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node;

import com.alipay.sofa.registry.net.NetUtil;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionProcessIdGenerator {
    private static volatile String processId;
    private static final String EMPTY_STRING = "";
    private static final String PID;
    private static AtomicInteger count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSessionProcessId() {
        if (processId != null) return processId;
        Class<SessionProcessIdGenerator> clazz = SessionProcessIdGenerator.class;
        synchronized (SessionProcessIdGenerator.class) {
            if (processId != null) return processId;
            processId = SessionProcessIdGenerator.generate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return processId;
        }
    }

    public static String generate() {
        String localIp = NetUtil.getLocalSocketAddress().getAddress().getHostAddress();
        if (localIp != null && !localIp.isEmpty()) {
            return SessionProcessIdGenerator.getId(SessionProcessIdGenerator.getIPHex(localIp), System.currentTimeMillis(), SessionProcessIdGenerator.getNextId());
        }
        return EMPTY_STRING;
    }

    private static String getId(String ip, long timestamp, int nextId) {
        StringBuilder appender = new StringBuilder(30);
        appender.append(ip).append(timestamp).append(nextId).append(PID);
        return appender.toString();
    }

    private static String getIPHex(String ip) {
        String[] ips = ip.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String column : ips) {
            String hex = Integer.toHexString(Integer.parseInt(column));
            if (hex.length() == 1) {
                sb.append('0').append(hex);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (SessionProcessIdGenerator.isBlank(processName)) {
            return EMPTY_STRING;
        }
        String[] processSplitName = processName.split("@");
        if (processSplitName.length == 0) {
            return EMPTY_STRING;
        }
        String pid = processSplitName[0];
        if (SessionProcessIdGenerator.isBlank(pid)) {
            return EMPTY_STRING;
        }
        return pid;
    }

    private static int getNextId() {
        int next;
        int current;
        while (!count.compareAndSet(current, next = (current = count.get()) > 9000 ? 1000 : current + 1)) {
        }
        return next;
    }

    private static boolean isBlank(String str) {
        return str == null || str.isEmpty();
    }

    static {
        PID = SessionProcessIdGenerator.getPID();
        count = new AtomicInteger(1000);
    }
}

