/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.listener;

import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.task.DataPushTask;
import com.alipay.sofa.registry.server.session.scheduler.task.SessionTask;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.task.batcher.TaskDispatcher;
import com.alipay.sofa.registry.task.batcher.TaskDispatchers;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListener;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import org.springframework.beans.factory.annotation.Autowired;

public class DataPushTaskListener
implements TaskListener {
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private TaskListenerManager taskListenerManager;
    @Autowired
    private ExecutorManager executorManager;
    private TaskDispatcher<String, SessionTask> singleTaskDispatcher;
    private TaskProcessor dataNodeSingleTaskProcessor;

    public DataPushTaskListener(TaskProcessor dataNodeSingleTaskProcessor) {
        this.dataNodeSingleTaskProcessor = dataNodeSingleTaskProcessor;
    }

    public TaskDispatcher<String, SessionTask> getSingleTaskDispatcher() {
        if (this.singleTaskDispatcher == null) {
            this.singleTaskDispatcher = TaskDispatchers.createDefaultSingleTaskDispatcher((String)TaskEvent.TaskType.DATA_PUSH_TASK.getName(), (TaskProcessor)this.dataNodeSingleTaskProcessor);
        }
        return this.singleTaskDispatcher;
    }

    public boolean support(TaskEvent event) {
        return TaskEvent.TaskType.DATA_PUSH_TASK.equals((Object)event.getTaskType());
    }

    public void handleEvent(TaskEvent event) {
        DataPushTask dataPushTask = new DataPushTask(this.sessionInterests, this.sessionServerConfig, this.executorManager, this.taskListenerManager);
        dataPushTask.setTaskEvent(event);
        this.getSingleTaskDispatcher().dispatch((Object)dataPushTask.getTaskId(), (Object)dataPushTask, dataPushTask.getExpiryTime());
    }
}

