/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.converter;

import com.alipay.sofa.registry.common.model.ServerDataBox;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.DataBox;
import com.alipay.sofa.registry.core.model.PublisherRegister;
import com.alipay.sofa.registry.server.session.converter.Converter;
import java.util.ArrayList;
import java.util.List;

public class PublisherConverter {
    public static Publisher convert(PublisherRegister publisherRegister) {
        Converter<PublisherRegister, Publisher> messageToData = source -> {
            Publisher publisher = new Publisher();
            publisher.setAppName(source.getAppName());
            publisher.setCell(source.getZone());
            publisher.setClientId(source.getClientId());
            publisher.setDataId(source.getDataId());
            publisher.setGroup(source.getGroup());
            publisher.setInstanceId(source.getInstanceId());
            publisher.setRegisterId(source.getRegistId());
            publisher.setProcessId(source.getProcessId());
            publisher.setVersion(source.getVersion());
            publisher.setRegisterTimestamp(System.currentTimeMillis());
            publisher.setClientRegisterTimestamp(source.getTimestamp().longValue());
            publisher.setSourceAddress(new URL(source.getIp(), source.getPort().intValue()));
            publisher.setClientVersion(BaseInfo.ClientVersion.StoreData);
            DataInfo dataInfo = new DataInfo(source.getInstanceId(), source.getDataId(), source.getGroup());
            publisher.setDataInfoId(dataInfo.getDataInfoId());
            publisher.setDataList(PublisherConverter.convert(source.getDataList()));
            return publisher;
        };
        return messageToData.convert(publisherRegister);
    }

    public static List<ServerDataBox> convert(List<DataBox> boxList) {
        ArrayList<ServerDataBox> serverDataBoxes = new ArrayList<ServerDataBox>();
        if (null != boxList) {
            for (DataBox dataBox : boxList) {
                ServerDataBox serverDataBox = new ServerDataBox(ServerDataBox.getBytes((Object)dataBox.getData()));
                serverDataBoxes.add(serverDataBox);
            }
        }
        return serverDataBoxes;
    }
}

