/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.cache;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.cache.CacheGenerator;
import com.alipay.sofa.registry.server.session.cache.DatumKey;
import com.alipay.sofa.registry.server.session.cache.EntityType;
import com.alipay.sofa.registry.server.session.cache.Key;
import com.alipay.sofa.registry.server.session.cache.Value;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import org.springframework.beans.factory.annotation.Autowired;

public class DatumCacheGenerator
implements CacheGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatumCacheGenerator.class);
    @Autowired
    private DataNodeService dataNodeService;

    @Override
    public Value generatePayload(Key key) {
        EntityType entityType = key.getEntityType();
        if (entityType instanceof DatumKey) {
            DatumKey datumKey = (DatumKey)entityType;
            String dataCenter = datumKey.getDataCenter();
            String dataInfoId = datumKey.getDataInfoId();
            if (this.isNotBlank(dataCenter) && this.isNotBlank(dataInfoId)) {
                return new Value<Datum>(this.dataNodeService.fetchDataCenter(dataInfoId, dataCenter));
            }
            LOGGER.warn("Input key " + key + " invalid!");
        } else {
            LOGGER.warn("Input key " + key + " invalid!");
        }
        return null;
    }

    public boolean isNotBlank(String ss) {
        return ss != null && !ss.isEmpty();
    }
}

