/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.bootstrap;

import com.alipay.sofa.registry.remoting.bolt.exchange.BoltExchange;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.jersey.exchange.JerseyExchange;
import com.alipay.sofa.registry.server.session.bootstrap.CommonConfig;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerBootstrap;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfigBean;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerInitializer;
import com.alipay.sofa.registry.server.session.cache.CacheGenerator;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.cache.DatumCacheGenerator;
import com.alipay.sofa.registry.server.session.cache.SessionCacheService;
import com.alipay.sofa.registry.server.session.listener.CancelDataTaskListener;
import com.alipay.sofa.registry.server.session.listener.DataChangeFetchCloudTaskListener;
import com.alipay.sofa.registry.server.session.listener.DataChangeFetchTaskListener;
import com.alipay.sofa.registry.server.session.listener.DataPushTaskListener;
import com.alipay.sofa.registry.server.session.listener.ProvideDataChangeFetchTaskListener;
import com.alipay.sofa.registry.server.session.listener.ReceivedConfigDataPushTaskListener;
import com.alipay.sofa.registry.server.session.listener.ReceivedDataMultiPushTaskListener;
import com.alipay.sofa.registry.server.session.listener.SessionRegisterDataTaskListener;
import com.alipay.sofa.registry.server.session.listener.SubscriberMultiFetchTaskListener;
import com.alipay.sofa.registry.server.session.listener.SubscriberRegisterFetchTaskListener;
import com.alipay.sofa.registry.server.session.listener.WatcherRegisterFetchTaskListener;
import com.alipay.sofa.registry.server.session.node.DataNodeManager;
import com.alipay.sofa.registry.server.session.node.MetaNodeManager;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.NodeManagerFactory;
import com.alipay.sofa.registry.server.session.node.RaftClientManager;
import com.alipay.sofa.registry.server.session.node.SessionNodeManager;
import com.alipay.sofa.registry.server.session.node.processor.ClientNodeSingleTaskProcessor;
import com.alipay.sofa.registry.server.session.node.processor.ConsoleSyncSingleTaskProcessor;
import com.alipay.sofa.registry.server.session.node.processor.DataNodeSingleTaskProcessor;
import com.alipay.sofa.registry.server.session.node.processor.MetaNodeSingleTaskProcessor;
import com.alipay.sofa.registry.server.session.node.service.ClientNodeService;
import com.alipay.sofa.registry.server.session.node.service.ClientNodeServiceImpl;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.server.session.node.service.DataNodeServiceImpl;
import com.alipay.sofa.registry.server.session.node.service.MetaNodeService;
import com.alipay.sofa.registry.server.session.node.service.MetaNodeServiceImpl;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.registry.SessionRegistry;
import com.alipay.sofa.registry.server.session.remoting.ClientNodeExchanger;
import com.alipay.sofa.registry.server.session.remoting.DataNodeExchanger;
import com.alipay.sofa.registry.server.session.remoting.MetaNodeExchanger;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.CancelAddressRequestHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.ClientNodeConnectionHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.DataChangeRequestHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.DataNodeConnectionHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.DataPushRequestHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.MetaNodeConnectionHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.NodeChangeResultHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.NotifyProvideDataChangeHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.PublisherHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.SubscriberHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.SyncConfigHandler;
import com.alipay.sofa.registry.server.session.remoting.handler.WatcherHandler;
import com.alipay.sofa.registry.server.session.resource.ClientsOpenResource;
import com.alipay.sofa.registry.server.session.resource.HealthResource;
import com.alipay.sofa.registry.server.session.resource.SessionDigestResource;
import com.alipay.sofa.registry.server.session.resource.SessionOpenResource;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.timertask.SyncClientsHeartbeatTask;
import com.alipay.sofa.registry.server.session.store.DataStore;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.SessionDataStore;
import com.alipay.sofa.registry.server.session.store.SessionInterests;
import com.alipay.sofa.registry.server.session.store.SessionWatchers;
import com.alipay.sofa.registry.server.session.store.Watchers;
import com.alipay.sofa.registry.server.session.strategy.DataChangeRequestHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.PublisherHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.ReceivedConfigDataPushTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.ReceivedDataMultiPushTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.SessionRegistryStrategy;
import com.alipay.sofa.registry.server.session.strategy.SubscriberHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.SubscriberMultiFetchTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.SubscriberRegisterFetchTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.SyncConfigHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.TaskMergeProcessorStrategy;
import com.alipay.sofa.registry.server.session.strategy.WatcherHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultDataChangeRequestHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultPublisherHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultPushTaskMergeProcessor;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultReceivedConfigDataPushTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultReceivedDataMultiPushTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultSessionRegistryStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultSubscriberHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultSubscriberMultiFetchTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultSubscriberRegisterFetchTaskStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultSyncConfigHandlerStrategy;
import com.alipay.sofa.registry.server.session.strategy.impl.DefaultWatcherHandlerStrategy;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.DefaultTaskListenerManager;
import com.alipay.sofa.registry.task.listener.TaskListener;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import com.alipay.sofa.registry.util.PropertySplitter;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={SessionServerInitializer.class})
@EnableConfigurationProperties
public class SessionServerConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SessionServerBootstrap sessionServerBootstrap() {
        return new SessionServerBootstrap();
    }

    @Configuration
    public static class SessionStrategyConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SessionRegistryStrategy sessionRegistryStrategy() {
            return new DefaultSessionRegistryStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public DataChangeRequestHandlerStrategy dataChangeRequestHandlerStrategy() {
            return new DefaultDataChangeRequestHandlerStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public SyncConfigHandlerStrategy syncConfigHandlerStrategy() {
            return new DefaultSyncConfigHandlerStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public SubscriberRegisterFetchTaskStrategy subscriberRegisterFetchTaskStrategy() {
            return new DefaultSubscriberRegisterFetchTaskStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public SubscriberMultiFetchTaskStrategy subscriberMultiFetchTaskStrategy() {
            return new DefaultSubscriberMultiFetchTaskStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public PublisherHandlerStrategy publisherHandlerStrategy() {
            return new DefaultPublisherHandlerStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public SubscriberHandlerStrategy subscriberHandlerStrategy() {
            return new DefaultSubscriberHandlerStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public WatcherHandlerStrategy watcherHandlerStrategy() {
            return new DefaultWatcherHandlerStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public TaskMergeProcessorStrategy receiveDataTaskMergeProcessorStrategy() {
            return new DefaultPushTaskMergeProcessor();
        }

        @Bean
        @ConditionalOnMissingBean
        public ReceivedDataMultiPushTaskStrategy receivedDataMultiPushTaskStrategy() {
            return new DefaultReceivedDataMultiPushTaskStrategy();
        }

        @Bean
        @ConditionalOnMissingBean
        public ReceivedConfigDataPushTaskStrategy receivedConfigDataPushTaskStrategy() {
            return new DefaultReceivedConfigDataPushTaskStrategy();
        }
    }

    @Configuration
    public static class SessionTimerTaskConfiguration {
        @Bean
        public SyncClientsHeartbeatTask syncClientsHeartbeatTask() {
            return new SyncClientsHeartbeatTask();
        }
    }

    @Configuration
    public static class ExecutorConfiguration {
        @Bean
        public ExecutorManager executorManager(SessionServerConfig sessionServerConfig) {
            return new ExecutorManager(sessionServerConfig);
        }
    }

    @Configuration
    public static class SessionTaskConfiguration {
        @Bean
        public TaskProcessor dataNodeSingleTaskProcessor() {
            return new DataNodeSingleTaskProcessor();
        }

        @Bean
        public TaskProcessor metaNodeSingleTaskProcessor() {
            return new MetaNodeSingleTaskProcessor();
        }

        @Bean
        public TaskProcessor clientNodeSingleTaskProcessor() {
            return new ClientNodeSingleTaskProcessor();
        }

        @Bean
        public TaskProcessor consoleSyncSingleTaskProcessor() {
            return new ConsoleSyncSingleTaskProcessor();
        }

        @Bean
        public TaskListener subscriberRegisterFetchTaskListener(TaskListenerManager taskListenerManager) {
            SubscriberRegisterFetchTaskListener taskListener = new SubscriberRegisterFetchTaskListener(this.dataNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener subscriberMultiFetchTaskListener(TaskListenerManager taskListenerManager) {
            SubscriberMultiFetchTaskListener taskListener = new SubscriberMultiFetchTaskListener(this.dataNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener watcherRegisterFetchTaskListener(TaskListenerManager taskListenerManager) {
            WatcherRegisterFetchTaskListener taskListener = new WatcherRegisterFetchTaskListener(this.metaNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener provideDataChangeFetchTaskListener(TaskListenerManager taskListenerManager) {
            ProvideDataChangeFetchTaskListener taskListener = new ProvideDataChangeFetchTaskListener(this.metaNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener dataChangeFetchTaskListener(TaskListenerManager taskListenerManager) {
            DataChangeFetchTaskListener taskListener = new DataChangeFetchTaskListener(this.dataNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener dataPushTaskListener(TaskListenerManager taskListenerManager) {
            DataPushTaskListener taskListener = new DataPushTaskListener(this.dataNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener dataChangeFetchCloudTaskListener(TaskListenerManager taskListenerManager) {
            DataChangeFetchCloudTaskListener taskListener = new DataChangeFetchCloudTaskListener(this.dataNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener sessionRegisterDataTaskListener(TaskListenerManager taskListenerManager) {
            SessionRegisterDataTaskListener taskListener = new SessionRegisterDataTaskListener(this.dataNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener receivedDataMultiPushTaskListener(TaskListenerManager taskListenerManager, TaskMergeProcessorStrategy receiveDataTaskMergeProcessorStrategy, SessionServerConfig sessionServerConfig) {
            ReceivedDataMultiPushTaskListener taskListener = new ReceivedDataMultiPushTaskListener(this.clientNodeSingleTaskProcessor(), receiveDataTaskMergeProcessorStrategy, sessionServerConfig);
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener receivedConfigDataPushTaskListener(TaskListenerManager taskListenerManager) {
            ReceivedConfigDataPushTaskListener taskListener = new ReceivedConfigDataPushTaskListener(this.clientNodeSingleTaskProcessor());
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListener cancelDataTaskListener(TaskListenerManager taskListenerManager) {
            CancelDataTaskListener taskListener = new CancelDataTaskListener();
            taskListenerManager.addTaskListener((TaskListener)taskListener);
            return taskListener;
        }

        @Bean
        public TaskListenerManager taskListenerManager() {
            return new DefaultTaskListenerManager();
        }
    }

    @Configuration
    public static class SessionCacheConfiguration {
        @Bean
        public CacheService sessionCacheService() {
            return new SessionCacheService();
        }

        @Bean(name={"com.alipay.sofa.registry.server.session.cache.DatumKey"})
        public CacheGenerator datumCacheGenerator() {
            return new DatumCacheGenerator();
        }
    }

    @Configuration
    public static class SessionNodeConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public DataNodeService dataNodeService() {
            return new DataNodeServiceImpl();
        }

        @Bean
        public MetaNodeService mataNodeService() {
            return new MetaNodeServiceImpl();
        }

        @Bean
        @ConditionalOnMissingBean
        public ClientNodeService clientNodeService() {
            return new ClientNodeServiceImpl();
        }

        @Bean
        public NodeManager dataNodeManager() {
            return new DataNodeManager();
        }

        @Bean
        public NodeManager sessionNodeManager() {
            return new SessionNodeManager();
        }

        @Bean
        public NodeManager metaNodeManager() {
            return new MetaNodeManager();
        }

        @Bean
        public RaftClientManager raftClientManager() {
            return new RaftClientManager();
        }

        @Bean
        public NodeManagerFactory nodeManagerFactory() {
            return new NodeManagerFactory();
        }
    }

    @Configuration
    public static class SessionRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"sessionRegistry"})
        public Registry sessionRegistry() {
            return new SessionRegistry();
        }

        @Bean
        @ConditionalOnMissingBean
        public Interests sessionInterests() {
            return new SessionInterests();
        }

        @Bean
        @ConditionalOnMissingBean
        public Watchers sessionWatchers() {
            return new SessionWatchers();
        }

        @Bean
        @ConditionalOnMissingBean
        public DataStore sessionDataStore() {
            return new SessionDataStore();
        }
    }

    @Configuration
    public static class ResourceConfiguration {
        @Bean
        public ResourceConfig jerseyResourceConfig() {
            ResourceConfig resourceConfig = new ResourceConfig();
            resourceConfig.register(JacksonFeature.class);
            return resourceConfig;
        }

        @Bean
        @ConditionalOnMissingBean(name={"sessionOpenResource"})
        public SessionOpenResource sessionOpenResource() {
            return new SessionOpenResource();
        }

        @Bean
        public SessionDigestResource sessionDigestResource() {
            return new SessionDigestResource();
        }

        @Bean
        @ConditionalOnMissingBean(name={"healthResource"})
        public HealthResource healthResource() {
            return new HealthResource();
        }

        @Bean
        public ClientsOpenResource clientsOpenResource() {
            return new ClientsOpenResource();
        }
    }

    @Configuration
    public static class SessionRemotingConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"boltExchange"})
        public Exchange boltExchange() {
            return new BoltExchange();
        }

        @Bean
        public Exchange jerseyExchange() {
            return new JerseyExchange();
        }

        @Bean
        public NodeExchanger clientNodeExchanger() {
            return new ClientNodeExchanger();
        }

        @Bean
        public NodeExchanger dataNodeExchanger() {
            return new DataNodeExchanger();
        }

        @Bean
        public NodeExchanger metaNodeExchanger() {
            return new MetaNodeExchanger();
        }

        @Bean(name={"serverHandlers"})
        public Collection<AbstractServerHandler> serverHandlers() {
            ArrayList<AbstractServerHandler> list = new ArrayList<AbstractServerHandler>();
            list.add(this.publisherHandler());
            list.add(this.subscriberHandler());
            list.add(this.watcherHandler());
            list.add(this.clientNodeConnectionHandler());
            list.add(this.cancelAddressRequestHandler());
            list.add(this.syncConfigHandler());
            return list;
        }

        @Bean
        public AbstractServerHandler publisherHandler() {
            return new PublisherHandler();
        }

        @Bean
        public AbstractServerHandler syncConfigHandler() {
            return new SyncConfigHandler();
        }

        @Bean
        public AbstractServerHandler subscriberHandler() {
            return new SubscriberHandler();
        }

        @Bean
        public AbstractServerHandler watcherHandler() {
            return new WatcherHandler();
        }

        @Bean
        public AbstractServerHandler clientNodeConnectionHandler() {
            return new ClientNodeConnectionHandler();
        }

        @Bean
        public AbstractServerHandler cancelAddressRequestHandler() {
            return new CancelAddressRequestHandler();
        }

        @Bean(name={"dataClientHandlers"})
        public Collection<AbstractClientHandler> dataClientHandlers() {
            ArrayList<AbstractClientHandler> list = new ArrayList<AbstractClientHandler>();
            list.add(this.dataNodeConnectionHandler());
            list.add(this.dataChangeRequestHandler());
            list.add(this.dataPushRequestHandler());
            return list;
        }

        @Bean(name={"metaClientHandlers"})
        public Collection<AbstractClientHandler> metaClientHandlers() {
            ArrayList<AbstractClientHandler> list = new ArrayList<AbstractClientHandler>();
            list.add(this.metaNodeConnectionHandler());
            list.add(this.nodeChangeResultHandler());
            list.add(this.notifyProvideDataChangeHandler());
            return list;
        }

        @Bean
        public AbstractClientHandler metaNodeConnectionHandler() {
            return new MetaNodeConnectionHandler();
        }

        @Bean
        public AbstractClientHandler dataNodeConnectionHandler() {
            return new DataNodeConnectionHandler();
        }

        @Bean
        public AbstractClientHandler dataChangeRequestHandler() {
            return new DataChangeRequestHandler();
        }

        @Bean
        public AbstractClientHandler dataPushRequestHandler() {
            return new DataPushRequestHandler();
        }

        @Bean
        public AbstractClientHandler nodeChangeResultHandler() {
            return new NodeChangeResultHandler();
        }

        @Bean
        public AbstractClientHandler notifyProvideDataChangeHandler() {
            return new NotifyProvideDataChangeHandler();
        }
    }

    @Configuration
    public static class SessionServerConfigBeanConfiguration {
        @Bean
        public CommonConfig commonConfig() {
            return new CommonConfig();
        }

        @Bean
        @ConditionalOnMissingBean(name={"sessionServerConfig"})
        public SessionServerConfig sessionServerConfig(CommonConfig commonConfig) {
            return new SessionServerConfigBean(commonConfig);
        }

        @Bean(name={"PropertySplitter"})
        public PropertySplitter propertySplitter() {
            return new PropertySplitter();
        }
    }
}

