/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.metaserver;

import com.alipay.remoting.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MetaServerConnectionFactory {
    private final Map<String, Map<String, Connection>> MAP = new ConcurrentHashMap<String, Map<String, Connection>>();

    public void register(String dataCenter, String ip, Connection connection) {
        ConcurrentHashMap<String, Connection> newConnectionMap;
        ConcurrentHashMap<String, Connection> connectionMap = this.MAP.get(dataCenter);
        if (connectionMap == null && (connectionMap = (ConcurrentHashMap<String, Connection>)this.MAP.putIfAbsent(dataCenter, newConnectionMap = new ConcurrentHashMap<String, Connection>())) == null) {
            connectionMap = newConnectionMap;
        }
        connectionMap.put(ip, connection);
    }

    public Connection getConnection(String dataCenter, String ip) {
        Map<String, Connection> map;
        if (this.MAP.containsKey(dataCenter) && (map = this.MAP.get(dataCenter)).containsKey(ip)) {
            return map.get(ip);
        }
        return null;
    }

    public Map<String, Connection> getConnections(String dataCenter) {
        if (this.MAP.containsKey(dataCenter)) {
            return this.MAP.get(dataCenter);
        }
        return new HashMap<String, Connection>();
    }

    public Set<String> getIps(String dataCenter) {
        Map<String, Connection> map;
        if (this.MAP.containsKey(dataCenter) && (map = this.MAP.get(dataCenter)) != null) {
            return map.keySet();
        }
        return new HashSet<String>();
    }

    public void remove(String dataCenter) {
        Map<String, Connection> map = this.getConnections(dataCenter);
        if (!map.isEmpty()) {
            for (Connection connection : map.values()) {
                if (!connection.isFine()) continue;
                connection.close();
            }
        }
        this.MAP.remove(dataCenter);
    }

    public void remove(String dataCenter, String ip) {
        Map<String, Connection> map;
        if (this.MAP.containsKey(dataCenter) && (map = this.MAP.get(dataCenter)) != null) {
            map.remove(ip);
        }
    }

    public Set<String> getAllDataCenters() {
        return this.MAP.keySet();
    }
}

