/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.event.handler;

import com.alipay.remoting.Connection;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DataServerCache;
import com.alipay.sofa.registry.server.data.cache.DataServerChangeItem;
import com.alipay.sofa.registry.server.data.event.DataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import com.alipay.sofa.registry.server.data.event.LocalDataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.handler.AbstractEventHandler;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.alipay.sofa.registry.server.data.remoting.DataNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerNodeFactory;
import com.alipay.sofa.registry.server.data.util.TimeUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DataServerChangeEventHandler
extends AbstractEventHandler<DataServerChangeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataServerChangeEventHandler.class);
    private static final int TRY_COUNT = 5;
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Autowired
    private DataServerCache dataServerCache;
    @Autowired
    private DataNodeExchanger dataNodeExchanger;
    @Autowired
    private EventCenter eventCenter;

    @Override
    public Class interest() {
        return DataServerChangeEvent.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHandle(DataServerChangeEvent event) {
        DataServerChangeEventHandler dataServerChangeEventHandler = this;
        synchronized (dataServerChangeEventHandler) {
            DataServerNodeFactory.initConsistent(this.dataServerBootstrapConfig);
            DataServerChangeItem dataServerChangeItem = event.getDataServerChangeItem();
            Set<String> localDataServers = this.dataServerCache.getDataServers(this.dataServerBootstrapConfig.getLocalDataCenter()).keySet();
            Map<String, Set<String>> changedMap = this.dataServerCache.compareAndSet(dataServerChangeItem);
            if (!changedMap.isEmpty()) {
                for (Map.Entry<String, Set<String>> changeEntry : changedMap.entrySet()) {
                    String dataCenter = changeEntry.getKey();
                    Set<String> ips = changeEntry.getValue();
                    if (!CollectionUtils.isEmpty(ips)) {
                        for (String string : ips) {
                            DataServerNode dataServerNode2;
                            if (StringUtils.equals((String)string, (String)DataServerConfig.IP) || (dataServerNode2 = DataServerNodeFactory.getDataServerNode(dataCenter, string)) != null && dataServerNode2.getConnection() != null && dataServerNode2.getConnection().isFine()) continue;
                            this.connectDataServer(dataCenter, string);
                        }
                        Set<String> ipSet = DataServerNodeFactory.getIps(dataCenter);
                        for (String ip3 : ipSet) {
                            if (ips.contains(ip3)) continue;
                            DataServerNodeFactory.remove(dataCenter, ip3, this.dataServerBootstrapConfig);
                            LOGGER.info("[DataServerChangeEventHandler] remove connection, datacenter:{}, ip:{}", (Object)dataCenter, (Object)ip3);
                        }
                        Long l = this.dataServerCache.getDataCenterNewVersion(dataCenter);
                        Map<String, DataNode> newDataNodes = this.dataServerCache.getNewDataServerMap(dataCenter);
                        if (this.dataServerBootstrapConfig.getLocalDataCenter().equals(dataCenter)) {
                            HashSet<String> newjoined = new HashSet<String>(ips);
                            newjoined.removeAll(localDataServers);
                            ConcurrentHashMap<String, DataNode> map = new ConcurrentHashMap<String, DataNode>(newDataNodes);
                            LOGGER.info("Node list change fire LocalDataServerChangeEvent,current node list={},version={}", map.keySet(), (Object)l);
                            this.eventCenter.post(new LocalDataServerChangeEvent(map, newjoined, dataServerChangeItem.getVersionMap().get(this.dataServerBootstrapConfig.getLocalDataCenter()), l));
                            continue;
                        }
                        this.dataServerCache.updateItem(newDataNodes, l, dataCenter);
                        continue;
                    }
                    if (!this.dataServerBootstrapConfig.getLocalDataCenter().equals(dataCenter)) {
                        this.removeDataCenter(dataCenter);
                    }
                    Long newVersion = this.dataServerCache.getDataCenterNewVersion(dataCenter);
                    Map<String, DataNode> map = this.dataServerCache.getNewDataServerMap(dataCenter);
                    this.dataServerCache.updateItem(map, newVersion, dataCenter);
                }
            } else {
                HashSet<String> allDataCenter = new HashSet<String>(DataServerNodeFactory.getAllDataCenters());
                for (String dataCenter : allDataCenter) {
                    Map<String, DataServerNode> dataNodes = DataServerNodeFactory.getDataServerNodes(dataCenter);
                    if (dataNodes == null || dataNodes.isEmpty()) continue;
                    dataNodes.forEach((ip, dataServerNode) -> {
                        Connection connection;
                        if (!StringUtils.equals((String)ip, (String)DataServerConfig.IP) && (connection = dataServerNode.getConnection()) != null && !connection.isFine()) {
                            LOGGER.warn("[DataServerChangeEventHandler] dataServer connections is not fine,try to reconnect it,old connection={},dataCenter={}", (Object)connection.getRemoteAddress(), (Object)dataCenter);
                            this.connectDataServer(dataCenter, (String)ip);
                        }
                    });
                }
            }
        }
    }

    private void connectDataServer(String dataCenter, String ip) {
        Connection conn = null;
        for (int tryCount = 0; tryCount < 5; ++tryCount) {
            try {
                conn = ((BoltChannel)this.dataNodeExchanger.connect(new URL(ip, this.dataServerBootstrapConfig.getSyncDataPort()))).getConnection();
                break;
            }
            catch (Exception e) {
                LOGGER.error("[DataServerChangeEventHandler] connect dataServer {} in {} error", new Object[]{ip, dataCenter, e});
                TimeUtil.randomDelay(3000);
                continue;
            }
        }
        if (conn == null || !conn.isFine()) {
            LOGGER.error("[DataServerChangeEventHandler] connect dataserver {} in {} failed five times", (Object)ip, (Object)dataCenter);
            throw new RuntimeException(String.format("[DataServerChangeEventHandler] connect dataserver %s in %s failed five times,dataServer will not work,please check connect!", ip, dataCenter));
        }
        DataServerNodeFactory.register(new DataServerNode(ip, dataCenter, conn), this.dataServerBootstrapConfig);
    }

    private void removeDataCenter(String dataCenter) {
        DataServerNodeFactory.getDataServerNodes(dataCenter).values().stream().map(DataServerNode::getConnection).filter(connection -> connection != null && connection.isFine()).forEach(Connection::close);
        DataServerNodeFactory.remove(dataCenter);
        LOGGER.info("[DataServerChangeEventHandler] remove connections of datacenter : {}", (Object)dataCenter);
    }
}

